DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -3.52151091401099E-12   0.00000000000000E+00  -7.63373197566721E-10   1.59629341615395E-22
      4.28496253621328E-09   3.52158933864672E-09  -7.94952621556922E-19  -2.47846792153655E-01  -2.47846792161901E-01
      0.00000000000000E+00   0.00000000000000E+00   8.24663290356246E-09   0.00000000000000E+00   8.24663290356246E-09
      3.70485193211918E-18  -2.47846792153657E-01  -2.44139204126640E-01   0.00000000000000E+00   2.44091921865834E-11
     -9.83204380319232E-23  -1.17926314343964E-08  -1.17682222422100E-08  -2.90989931056226E-18
      1.17500000000000E-12
      0.00000000000000E+00  -3.54245151409431E-12   0.00000000000000E+00  -5.10456624953027E-11   1.52004576583289E-22
      3.59345855806473E-09   3.54241289556958E-09  -7.99779131575750E-19  -2.45758708979508E-01  -2.45758708987284E-01
      0.00000000000000E+00   0.00000000000000E+00   7.77521311473950E-09   0.00000000000000E+00   7.77521311473950E-09
      3.71010020097163E-18  -2.45758708979509E-01  -2.42193067398457E-01   0.00000000000000E+00   3.28865241601331E-11
     -9.82940725672043E-23  -1.13505125344696E-08  -1.13176260103096E-08  -2.91032106939588E-18
      1.63062500000000E-12
      0.00000000000000E+00  -3.55549346677778E-12   0.00000000000000E+00  -4.01579895919775E-12   1.46010493403266E-22
      3.55948600423062E-09   3.55547020527157E-09  -8.02853241040652E-19  -2.44452979472817E-01  -2.44452979480242E-01
      0.00000000000000E+00   0.00000000000000E+00   7.42462877088371E-09   0.00000000000000E+00   7.42462877088371E-09
      3.71348304745536E-18  -2.44452979472818E-01  -2.40993677520441E-01   0.00000000000000E+00   3.60857367397281E-11
     -9.82760747166181E-23  -1.10161847128962E-08  -1.09800989761566E-08  -2.91062980641471E-18
      2.24571875000000E-12
      0.00000000000000E+00  -3.57184183000072E-12   0.00000000000000E+00   6.59592509603227E-13   1.37576381171118E-22
      3.57118559781476E-09   3.57184519032450E-09  -8.06706042853563E-19  -2.42815955710230E-01  -2.42815955717168E-01
      0.00000000000000E+00   0.00000000000000E+00   6.93804596275709E-09   0.00000000000000E+00   6.93804596275709E-09
      3.71775059616427E-18  -2.42815955710230E-01  -2.39504795656913E-01   0.00000000000000E+00   3.69561031080143E-11
     -9.82529838228871E-23  -1.05468472561913E-08  -1.05098911530834E-08  -2.91104455331070E-18
      3.07609531250000E-12
      0.00000000000000E+00  -3.59195582744916E-12   0.00000000000000E+00   9.37089428086542E-13   1.26894946454530E-22
      3.59107293421711E-09   3.59201002364532E-09  -8.11436679895853E-19  -2.40800255159455E-01  -2.40800255165773E-01
      0.00000000000000E+00   0.00000000000000E+00   6.31788741015608E-09   0.00000000000000E+00   6.31788741015608E-09
      3.72299682179418E-18  -2.40800255159459E-01  -2.37678126630242E-01   0.00000000000000E+00   3.48666247865396E-11
     -9.82249396915120E-23  -9.94476405858708E-09  -9.90989743380064E-09  -2.91156014189832E-18
      4.19710367187500E-12
      0.00000000000000E+00  -3.61620283807195E-12   0.00000000000000E+00   8.68596520963782E-13   1.14456091951097E-22
      3.61537908721880E-09   3.61624768373988E-09  -8.17101668032605E-19  -2.38378189372838E-01  -2.38378189378425E-01
      0.00000000000000E+00   0.00000000000000E+00   5.58781989012659E-09   0.00000000000000E+00   5.58781989012659E-09
      3.72926081460169E-18  -2.38378189372847E-01  -2.35478438652263E-01   0.00000000000000E+00   3.04549794873299E-11
     -9.81923041472119E-23  -9.23452255335418E-09  -9.20406757386695E-09  -2.91215914656908E-18
      5.71046495703125E-12
      0.00000000000000E+00  -3.64449101713187E-12   0.00000000000000E+00   7.86260592870615E-13   1.00902700181388E-22
      3.64375710408335E-09   3.64454336467632E-09  -8.23686434897760E-19  -2.35551938020394E-01  -2.35551938025179E-01
      0.00000000000000E+00   0.00000000000000E+00   4.78528303513331E-09   0.00000000000000E+00   4.78528303513331E-09
      3.73650267668558E-18  -2.35551938020403E-01  -2.32896123079461E-01   0.00000000000000E+00   2.48734346541191E-11
     -9.81556867310194E-23  -8.45469983446309E-09  -8.42982639980907E-09  -2.91281624178781E-18
      7.75350269199219E-12
      0.00000000000000E+00  -3.67636114094288E-12   0.00000000000000E+00   7.21475745359001E-13   8.69457917307389E-23
      3.67574073688644E-09   3.67646221263189E-09  -8.31077810893676E-19  -2.32365739487353E-01  -2.32365739491307E-01
      0.00000000000000E+00   0.00000000000000E+00   3.95445176751758E-09   0.00000000000000E+00   3.95445176751758E-09
      3.74458177086770E-18  -2.32365739487334E-01  -2.29961640487126E-01   0.00000000000000E+00   1.91337702969734E-11
     -9.81161074534103E-23  -7.65004775044580E-09  -7.63091398014892E-09  -2.91350395997402E-18
      1.05116036341895E-11
      0.00000000000000E+00  -3.71080291739570E-12   0.00000000000000E+00   6.84831636162842E-13   7.33096299336039E-23
      3.71036804437214E-09   3.71105287600838E-09  -8.39045543359340E-19  -2.28915116591932E-01  -2.28915116595073E-01
      0.00000000000000E+00   0.00000000000000E+00   3.14087052241950E-09   0.00000000000000E+00   3.14087052241950E-09
      3.75324460881490E-18  -2.28915116591939E-01  -2.26756465907675E-01   0.00000000000000E+00   1.38931442160161E-11
     -9.80750084469597E-23  -6.86581654264401E-09  -6.85192339842810E-09  -2.91419906545556E-18
      1.42350399061558E-11
      0.00000000000000E+00  -3.74643867543222E-12   0.00000000000000E+00   6.77315152169022E-13   6.06695687876797E-23
      3.74614472042426E-09   3.74682203557649E-09  -8.47241695963007E-19  -2.25348878470461E-01  -2.25348878472847E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38661385805407E-09   0.00000000000000E+00   2.38661385805407E-09
      3.76213101342116E-18  -2.25348878470504E-01  -2.23416621691367E-01   0.00000000000000E+00   9.49303899136945E-12
     -9.80341119778636E-23  -6.14292893262112E-09  -6.13343589362985E-09  -2.91488931745815E-18
      1.92616788733103E-11
      0.00000000000000E+00  -3.78143152030829E-12   0.00000000000000E+00   2.64572601898810E-13   4.95826342848424E-23
      3.78113982656952E-09   3.78140439917147E-09  -8.55226480720737E-19  -2.21859559985404E-01  -2.21859559987130E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72578446149102E-09   0.00000000000000E+00   1.72578446149102E-09
      3.77080590884420E-18  -2.21859559985430E-01  -2.20124505178258E-01   0.00000000000000E+00   6.47413893208007E-12
     -9.79952576106397E-23  -5.51366299959465E-09  -5.50718886066266E-09  -2.91557942812346E-18
      2.60476414789689E-11
      0.00000000000000E+00  -3.81339348885651E-12   0.00000000000000E+00   1.79139219147772E-13   4.04418383647024E-23
      3.81321398403959E-09   3.81339312325878E-09  -8.62522110948297E-19  -2.18660687563409E-01  -2.18660687564589E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18062220462922E-09   0.00000000000000E+00   1.18062220462922E-09
      3.77881756697622E-18  -2.18660687563424E-01  -2.17087308775633E-01   0.00000000000000E+00   4.05570452703072E-12
     -9.79598060809217E-23  -4.99807103241470E-09  -4.99401532788777E-09  -2.91629545602792E-18
      3.52086909966080E-11
      0.00000000000000E+00  -3.84048768633273E-12   0.00000000000000E+00   1.12461582543628E-13   3.34419034109514E-23
      3.84041500345589E-09   3.84052746503846E-09  -8.68701300030994E-19  -2.15947253417691E-01  -2.15947253418452E-01
      0.00000000000000E+00   0.00000000000000E+00   7.60671285362598E-10   0.00000000000000E+00   7.60671285362598E-10
      3.78578611428808E-18  -2.15947253417655E-01  -2.14497632068268E-01   0.00000000000000E+00   2.40587066892949E-12
     -9.79287249158414E-23  -4.60360462107008E-09  -4.60119875040125E-09  -2.91708481425708E-18
      4.75761078454208E-11
      0.00000000000000E+00  -3.86152013115325E-12   0.00000000000000E+00   6.46655423356513E-14   2.85753168880074E-23
      3.86145944734076E-09   3.86152411288313E-09  -8.73491195858690E-19  -2.13847588728161E-01  -2.13847588728624E-01
      0.00000000000000E+00   0.00000000000000E+00   4.62548650484580E-10   0.00000000000000E+00   4.62548650484580E-10
      3.79150664626147E-18  -2.13847588728185E-01  -2.12485276343851E-01   0.00000000000000E+00   1.35407327496761E-12
     -9.79020602745027E-23  -4.32542683664257E-09  -4.32407276336770E-09  -2.91801545040278E-18
      6.42721205913181E-11
      0.00000000000000E+00  -3.87621528910646E-12   0.00000000000000E+00   3.38159023496121E-14   2.56389556854947E-23
      3.87614690444353E-09   3.87618072034590E-09  -8.76860350078954E-19  -2.12381928031914E-01  -2.12381928032185E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71226427536975E-10   0.00000000000000E+00   2.71226427536975E-10
      3.79603504615265E-18  -2.12381928031932E-01  -2.11075274415395E-01   0.00000000000000E+00   7.34702207102818E-13
     -9.78787909902551E-23  -4.14814185008991E-09  -4.14740714788291E-09  -2.91917469607370E-18
      8.68117377982794E-11
      0.00000000000000E+00  -3.88549160756442E-12   0.00000000000000E+00   2.30063258480510E-13   2.42743856960974E-23
      3.88544492037855E-09   3.88567498363705E-09  -8.79032908743424E-19  -2.11453875673477E-01  -2.11453875673640E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62755968088263E-10   0.00000000000000E+00   1.62755968088263E-10
      3.79970350337151E-18  -2.11453875672348E-01  -2.10178471972063E-01   0.00000000000000E+00   1.90759722780247E-13
     -9.78568004660982E-23  -4.04862171144803E-09  -4.04843095172535E-09  -2.92067059462809E-18
      1.17240221027677E-10
      0.00000000000000E+00  -3.89109413653408E-12   0.00000000000000E+00   9.91906216630977E-14   2.40522221792725E-23
      3.89111902196700E-09   3.89121821258868E-09  -8.80403680646416E-19  -2.10887313073470E-01  -2.10887313073579E-01
      0.00000000000000E+00   0.00000000000000E+00   1.09633952864308E-10   0.00000000000000E+00   1.09633952864308E-10
      3.80303949826761E-18  -2.10887313072578E-01  -2.09626860534100E-01   0.00000000000000E+00   1.57530171861532E-13
     -9.78333976729642E-23  -4.00100969562474E-09  -4.00085216545298E-09  -2.92263581762120E-18
      1.58318673387364E-10
      0.00000000000000E+00  -3.89504346023400E-12   0.00000000000000E+00   3.17047992164082E-14   2.45998392982847E-23
      3.89501836098004E-09   3.89505006577928E-09  -8.81377204728246E-19  -2.10497725540724E-01  -2.10497725540811E-01
      0.00000000000000E+00   0.00000000000000E+00   8.69674039408825E-11   0.00000000000000E+00   8.69674039408825E-11
      3.80661198462725E-18  -2.10497725540032E-01  -2.09243186658579E-01   0.00000000000000E+00   1.57325473418646E-13
     -9.78053851989630E-23  -3.98217479519348E-09  -3.98201746972016E-09  -2.92523477989900E-18
      2.08318673387364E-10
      0.00000000000000E+00  -3.89825802603627E-12   0.00000000000000E+00   7.51411247938282E-15   2.55744649253962E-23
      3.89825197671385E-09   3.89825949082636E-09  -8.82177614392819E-19  -2.10174481968157E-01  -2.10174481968235E-01
      0.00000000000000E+00   0.00000000000000E+00   7.80785500471049E-11   0.00000000000000E+00   7.80785500471049E-11
      3.81051591212960E-18  -2.10174481968800E-01  -2.08921725060682E-01   0.00000000000000E+00   1.56482653657783E-13
     -9.77731027993234E-23  -3.97649452352705E-09  -3.97633804087349E-09  -2.92833829773679E-18
      2.58318673387364E-10
      0.00000000000000E+00  -3.90101336815249E-12   0.00000000000000E+00   3.15218208377302E-15   2.66161651408793E-23
      3.90102617848832E-09   3.90102933067043E-09  -8.82834609327647E-19  -2.09897100643700E-01  -2.09897100643774E-01
      0.00000000000000E+00   0.00000000000000E+00   7.41388985109017E-11   0.00000000000000E+00   7.41388985109017E-11
      3.81422285705515E-18  -2.09897100647143E-01  -2.08644710949687E-01   0.00000000000000E+00   1.50978082808553E-13
     -9.77417142422632E-23  -3.97531920726405E-09  -3.97516822918134E-09  -2.93138824772750E-18
      3.08318673387364E-10
      0.00000000000000E+00  -3.90358502079430E-12   0.00000000000000E+00   2.94095754017095E-15   2.76632211370677E-23
      3.90361867446305E-09   3.90362161542062E-09  -8.83415174768100E-19  -2.09637868277342E-01  -2.09637868277413E-01
      0.00000000000000E+00   0.00000000000000E+00   7.15937694985868E-11   0.00000000000000E+00   7.15937694985868E-11
      3.81780254553008E-18  -2.09637868280229E-01  -2.08385463629004E-01   0.00000000000000E+00   1.45655512513259E-13
     -9.77109584270607E-23  -3.97536104043163E-09  -3.97521538491922E-09  -2.93438737076198E-18
      3.58318673387364E-10
      0.00000000000000E+00  -3.90606482869891E-12   0.00000000000000E+00   2.57881395063307E-15   2.87002902866642E-23
      3.90610588966181E-09   3.90610846847579E-09  -8.83940731054813E-19  -2.09389158820089E-01  -2.09389158820159E-01
      0.00000000000000E+00   0.00000000000000E+00   6.95105742396458E-11   0.00000000000000E+00   6.95105742396458E-11
      3.82127807424206E-18  -2.09389158830442E-01  -2.08136626844281E-01   0.00000000000000E+00   1.41940486259633E-13
     -9.76807436904119E-23  -3.97576098320161E-09  -3.97561904271545E-09  -2.93733734318725E-18
      4.08318673387364E-10
      0.00000000000000E+00  -3.90854463660351E-12   0.00000000000000E+00   1.70228216965122E-15   2.97241356689011E-23
      3.90851155707653E-09   3.90851325935873E-09  -8.84420463090329E-19  -2.09148600888198E-01  -2.09148600888265E-01
      0.00000000000000E+00   0.00000000000000E+00   6.76368210048066E-11   0.00000000000000E+00   6.76368210048066E-11
      3.82465991529230E-18  -2.09148600905533E-01  -2.07895901286254E-01   0.00000000000000E+00   1.39364289111068E-13
     -9.76510385502598E-23  -3.97628944465254E-09  -3.97615008036353E-09  -2.94023945220197E-18
      4.58318673387364E-10
      0.00000000000000E+00  -3.91084075503370E-12   0.00000000000000E+00   2.14150407938427E-15   3.07345337987962E-23
      3.91084541810617E-09   3.91084755961028E-09  -8.84860011686291E-19  -2.08915224039594E-01  -2.08915224039659E-01
      0.00000000000000E+00   0.00000000000000E+00   6.58978497031452E-11   0.00000000000000E+00   6.58978497031452E-11
      3.82795480777746E-18  -2.08915224061850E-01  -2.07662336967608E-01   0.00000000000000E+00   1.35843298354189E-13
     -9.76218089146087E-23  -3.97688125261166E-09  -3.97674540931340E-09  -2.94309479609117E-18
      5.08318673387364E-10
      0.00000000000000E+00  -3.91313687346389E-12   0.00000000000000E+00   1.73308979716550E-15   3.17320262860344E-23
      3.91311319139349E-09   3.91311492448332E-09  -8.85263768894100E-19  -2.08688454068329E-01  -2.08688454068394E-01
      0.00000000000000E+00   0.00000000000000E+00   6.42664145173966E-11   0.00000000000000E+00   6.42664145173966E-11
      3.83116812850333E-18  -2.08688454088982E-01  -2.07435366460348E-01   0.00000000000000E+00   1.33420714090244E-13
     -9.75930424210238E-23  -3.97751475971470E-09  -3.97738133900071E-09  -2.94590435960923E-18
      5.58318673387364E-10
      0.00000000000000E+00  -3.91534114715687E-12   0.00000000000000E+00   2.04174367570653E-15   3.27172404683296E-23
      3.91531931404417E-09   3.91532135578788E-09  -8.85635500094770E-19  -2.08467849677589E-01  -2.08467849677652E-01
      0.00000000000000E+00   0.00000000000000E+00   6.27283878898910E-11   0.00000000000000E+00   6.27283878898910E-11
      3.83430454789782E-18  -2.08467849684585E-01  -2.07214551516154E-01   0.00000000000000E+00   1.30479976743000E-13
     -9.75647187996466E-23  -3.97818022365444E-09  -3.97804974367780E-09  -2.94866904780305E-18
      6.08318673387364E-10
      0.00000000000000E+00  -3.91745357611264E-12   0.00000000000000E+00   1.78836388535354E-15   3.36908011545574E-23
      3.91746754838113E-09   3.91746933674505E-09  -8.85978534277140E-19  -2.08253032701893E-01  -2.08253032701954E-01
      0.00000000000000E+00   0.00000000000000E+00   6.12738942448637E-11   0.00000000000000E+00   6.12738942448637E-11
      3.83736824261007E-18  -2.08253032679298E-01  -2.06999515891120E-01   0.00000000000000E+00   1.28255428142737E-13
     -9.75368262587336E-23  -3.97887148641795E-09  -3.97874323098991E-09  -2.95138970833292E-18
      6.58318673387364E-10
      0.00000000000000E+00  -3.91947416033120E-12   0.00000000000000E+00  -1.49944998705272E-16   3.46532633940808E-23
      3.91956129260126E-09   3.91956114265629E-09  -8.86295844277371E-19  -2.08043664303353E-01  -2.08043664303413E-01
      0.00000000000000E+00   0.00000000000000E+00   5.98949213642597E-11   0.00000000000000E+00   5.98949213642597E-11
      3.84036298867828E-18  -2.08043664245150E-01  -2.06789922211611E-01   0.00000000000000E+00   1.27834526775484E-13
     -9.75093517195697E-23  -3.97958389854719E-09  -3.97945606402051E-09  -2.95406714440091E-18
      7.08318673387364E-10
      0.00000000000000E+00  -3.92158658928698E-12   0.00000000000000E+00   1.79309793223854E-15   3.56051004396480E-23
      3.92160360530607E-09   3.92160539840404E-09  -8.86590081878721E-19  -2.07839439997202E-01  -2.07839439997260E-01
      0.00000000000000E+00   0.00000000000000E+00   5.85843493284475E-11   0.00000000000000E+00   5.85843493284475E-11
      3.84329220614470E-18  -2.07839439887617E-01  -2.06585467262917E-01   0.00000000000000E+00   1.23660023240820E-13
     -9.74822841780734E-23  -3.98031340775566E-09  -3.98018974773252E-09  -2.95670212426598E-18
      7.58318673387364E-10
      0.00000000000000E+00  -3.92360717350554E-12   0.00000000000000E+00   5.83121177029689E-16   3.65467800304874E-23
      3.92359723805152E-09   3.92359782117274E-09  -8.86863627225628E-19  -2.07640081451814E-01  -2.07640081451871E-01
      0.00000000000000E+00   0.00000000000000E+00   5.73362316613798E-11   0.00000000000000E+00   5.73362316613798E-11
      3.84615901772777E-18  -2.07640081301574E-01  -2.06385873744841E-01   0.00000000000000E+00   1.22714488756709E-13
     -9.74556136168189E-23  -3.98105676732278E-09  -3.98093405283412E-09  -2.95929539050214E-18
      8.08318673387364E-10
      0.00000000000000E+00  -3.92553591298690E-12   0.00000000000000E+00   1.76747535628211E-15   3.74786659759099E-23
      3.92554473712860E-09   3.92554650460400E-09  -8.87118600508943E-19  -2.07445336951595E-01  -2.07445336951651E-01
      0.00000000000000E+00   0.00000000000000E+00   5.61448948431933E-11   0.00000000000000E+00   5.61448948431933E-11
      3.84896626246993E-18  -2.07445336816068E-01  -2.06190890974030E-01   0.00000000000000E+00   1.19467414149839E-13
     -9.74293305548489E-23  -3.98181086686123E-09  -3.98169139944717E-09  -2.96184766196098E-18
      8.58318673387364E-10
      0.00000000000000E+00  -3.92746465246826E-12   0.00000000000000E+00   1.01847438103569E-15   3.84011253058479E-23
      3.92744838226857E-09   3.92744940074299E-09  -8.87356902616333E-19  -2.07254975878008E-01  -2.07254975878063E-01
      0.00000000000000E+00   0.00000000000000E+00   5.50056130106705E-11   0.00000000000000E+00   5.50056130106705E-11
      3.85171654312046E-18  -2.07254975831181E-01  -2.06000289119335E-01   0.00000000000000E+00   1.18209310232008E-13
     -9.74034264711347E-23  -3.98257322306385E-09  -3.98245501375372E-09  -2.96435964050413E-18
      9.08318673387364E-10
      0.00000000000000E+00  -3.92930154721241E-12   0.00000000000000E+00   1.72370535362754E-15   3.93144468214243E-23
      3.92931029126560E-09   3.92931201497099E-09  -8.87580226496192E-19  -2.07068788789619E-01  -2.07068788789672E-01
      0.00000000000000E+00   0.00000000000000E+00   5.39138804571821E-11   0.00000000000000E+00   5.39138804571821E-11
      3.85441223714332E-18  -2.07068788939012E-01  -2.05813859526898E-01   0.00000000000000E+00   1.15570400305236E-13
     -9.73778931832155E-23  -3.98334146582834E-09  -3.98322589542814E-09  -2.96683201064713E-18
      9.58318673387365E-10
      0.00000000000000E+00  -3.93113844195656E-12   0.00000000000000E+00   1.26527232610203E-15   4.02189196457899E-23
      3.93113236846050E-09   3.93113363373287E-09  -8.87790088074802E-19  -2.06886583343079E-01  -2.06886583343132E-01
      0.00000000000000E+00   0.00000000000000E+00   5.28659026879044E-11   0.00000000000000E+00   5.28659026879044E-11
      3.85705553227772E-18  -2.06886583786160E-01  -2.05631410437432E-01   0.00000000000000E+00   1.14138139145066E-13
     -9.73527232911504E-23  -3.98411367455982E-09  -3.98399953642077E-09  -2.96926544420291E-18
      1.00831867338736E-09
      0.00000000000000E+00  -3.93288349196350E-12   0.00000000000000E+00   1.67055808525367E-15   4.11147740329478E-23
      3.93291639553209E-09   3.93291806609021E-09  -8.87987837056838E-19  -2.06708184231846E-01  -2.06708184231898E-01
      0.00000000000000E+00   0.00000000000000E+00   5.18580719685847E-11   0.00000000000000E+00   5.18580719685847E-11
      3.85964843587615E-18  -2.06708184992751E-01  -2.05452767047647E-01   0.00000000000000E+00   1.11903115197189E-13
     -9.73279094339083E-23  -3.98488804117388E-09  -3.98477613805878E-09  -2.97166059881931E-18
      1.05831867338736E-09
      0.00000000000000E+00  -3.93462854197045E-12   0.00000000000000E+00   1.39366597065759E-15   4.20022388006508E-23
      3.93466397482290E-09   3.93466536848891E-09  -8.88174680879811E-19  -2.06533429997011E-01  -2.06533429997062E-01
      0.00000000000000E+00   0.00000000000000E+00   5.08873304871037E-11   0.00000000000000E+00   5.08873304871037E-11
      3.86219280240050E-18  -2.06533430961435E-01  -2.05277768217696E-01   0.00000000000000E+00   1.10385196485639E-13
     -9.73034450203583E-23  -3.98566308417245E-09  -3.98555269897606E-09  -2.97401812152069E-18
      1.10831867338736E-09
      0.00000000000000E+00  -3.93637359197739E-12   0.00000000000000E+00   1.61344719468532E-15   4.28814980640509E-23
      3.93637661995852E-09   3.93637823340575E-09  -8.88351694348127E-19  -2.06362172933580E-01  -2.06362172933630E-01
      0.00000000000000E+00   0.00000000000000E+00   4.99507740447523E-11   0.00000000000000E+00   4.99507740447523E-11
      3.86469034110274E-18  -2.06362173776853E-01  -2.05106266471318E-01   0.00000000000000E+00   1.08423084312096E-13
     -9.72793234625436E-23  -3.98643743053467E-09  -3.98632900745046E-09  -2.97633864675461E-18
      1.15831867338736E-09
      0.00000000000000E+00  -3.93802679724712E-12   0.00000000000000E+00   1.44890681428397E-15   4.37527335131821E-23
      3.93805567678916E-09   3.93805712569601E-09  -8.88519838544244E-19  -2.06194276451380E-01  -2.06194276451429E-01
      0.00000000000000E+00   0.00000000000000E+00   4.90459381815844E-11   0.00000000000000E+00   4.90459381815844E-11
      3.86714263801182E-18  -2.06194276637441E-01  -2.04938125358550E-01   0.00000000000000E+00   1.06874822604541E-13
     -9.72555388108157E-23  -3.98720993870012E-09  -3.98710306387761E-09  -2.97862279946757E-18
      1.20831867338736E-09
      0.00000000000000E+00  -3.93968000251686E-12   0.00000000000000E+00   1.55553186308585E-15   4.46160926930126E-23
      3.93970242459266E-09   3.93970398012457E-09  -8.88679969019807E-19  -2.06029615028816E-01  -2.06029615028864E-01
      0.00000000000000E+00   0.00000000000000E+00   4.81704826227068E-11   0.00000000000000E+00   4.81704826227068E-11
      3.86955116214295E-18  -2.06029613881384E-01  -2.04773219552639E-01   0.00000000000000E+00   1.05101707937114E-13
     -9.72320850769950E-23  -3.98797956445511E-09  -3.98787446274727E-09  -2.98087119312314E-18
      1.25831867338736E-09
      0.00000000000000E+00  -3.94133320778660E-12   0.00000000000000E+00   1.45967669432953E-15   4.54717201074357E-23
      3.94131798159667E-09   3.94131944127341E-09  -8.88832850821452E-19  -2.05868072000168E-01  -2.05868072000215E-01
      0.00000000000000E+00   0.00000000000000E+00   4.73224257647316E-11   0.00000000000000E+00   4.73224257647316E-11
      3.87191728343119E-18  -2.05868068958915E-01  -2.04611432775167E-01   0.00000000000000E+00   1.03556643839645E-13
     -9.72089568621219E-23  -3.98874542368189E-09  -3.98864186703815E-09  -2.98308443260974E-18
      1.30831867338736E-09
      0.00000000000000E+00  -3.94298641305633E-12   0.00000000000000E+00   1.49850947197207E-15   4.63197337807964E-23
      3.94290340076137E-09   3.94290489927089E-09  -8.88979165420656E-19  -2.05709539499984E-01  -2.05709539500030E-01
      0.00000000000000E+00   0.00000000000000E+00   4.64998864343003E-11   0.00000000000000E+00   4.64998864343003E-11
      3.87424227775290E-18  -2.05709534482635E-01  -2.04452657900325E-01   0.00000000000000E+00   1.01918253757086E-13
     -9.71861487296160E-23  -3.98950670395885E-09  -3.98940478570519E-09  -2.98526311233225E-18
      1.35831867338736E-09
      0.00000000000000E+00  -3.94445592885165E-12   0.00000000000000E+00   1.44391295084635E-15   4.71602487636192E-23
      3.94445960662729E-09   3.94446105054028E-09  -8.89119522207360E-19  -2.05553916826211E-01  -2.05553916826257E-01
      0.00000000000000E+00   0.00000000000000E+00   4.57012638946460E-11   0.00000000000000E+00   4.57012638946460E-11
      3.87652734094764E-18  -2.05553910705282E-01  -2.04296795393334E-01   0.00000000000000E+00   1.00395677514042E-13
     -9.71636557985866E-23  -3.99026271011237E-09  -3.99016231443495E-09  -2.98740781874027E-18
      1.40831867338736E-09
      0.00000000000000E+00  -3.94601728938418E-12   0.00000000000000E+00   1.44318275193370E-15   4.79933600372959E-23
      3.94598748685365E-09   3.94598893003646E-09  -8.89254464047393E-19  -2.05401110486254E-01  -2.05401110486299E-01
      0.00000000000000E+00   0.00000000000000E+00   4.49250246822823E-11   0.00000000000000E+00   4.49250246822823E-11
      3.87877359218175E-18  -2.05401105465941E-01  -2.04143753297290E-01   0.00000000000000E+00   9.88565607681101E-14
     -9.71414731407534E-23  -3.99101281127939E-09  -3.99091395471872E-09  -2.98951912813436E-18
      1.45831867338736E-09
      0.00000000000000E+00  -3.94748680517950E-12   0.00000000000000E+00   1.41287812998587E-15   4.88191607499607E-23
      3.94748786034567E-09   3.94748927322385E-09  -8.89384475840299E-19  -2.05251033109751E-01  -2.05251033109795E-01
      0.00000000000000E+00   0.00000000000000E+00   4.41698370831709E-11   0.00000000000000E+00   4.41698370831709E-11
      3.88098208403591E-18  -2.05251032733614E-01  -2.03993445742264E-01   0.00000000000000E+00   9.73671861322777E-14
     -9.71195962302700E-23  -3.99175647749308E-09  -3.99165911030704E-09  -2.99159760819561E-18
      1.50831867338736E-09
      0.00000000000000E+00  -3.94904816571203E-12   0.00000000000000E+00   1.39012539397998E-15   4.96377301563437E-23
      3.94896158827310E-09   3.94896297839854E-09  -8.89509988489226E-19  -2.05103603770713E-01  -2.05103603770757E-01
      0.00000000000000E+00   0.00000000000000E+00   4.34343862793960E-11   0.00000000000000E+00   4.34343862793960E-11
      3.88315380334988E-18  -2.05103612273479E-01  -2.03845792636810E-01   0.00000000000000E+00   9.59050737405803E-14
     -9.70980203997854E-23  -3.99249326975161E-09  -3.99239736467796E-09  -2.99364381486066E-18
      1.55831867338736E-09
      0.00000000000000E+00  -3.95042583677014E-12   0.00000000000000E+00   1.37387015897631E-15   5.04491480052126E-23
      3.95040957113116E-09   3.95041094500137E-09  -8.89631385009145E-19  -2.04958747410816E-01  -2.04958747410859E-01
      0.00000000000000E+00   0.00000000000000E+00   4.27174847600486E-11   0.00000000000000E+00   4.27174847600486E-11
      3.88528967758788E-18  -2.04958768103033E-01  -2.03700718088385E-01   0.00000000000000E+00   9.44562805798927E-14
     -9.70767411984866E-23  -3.99322288604185E-09  -3.99312842976137E-09  -2.99565829257874E-18
      1.60831867338736E-09
      0.00000000000000E+00  -3.95189535256546E-12   0.00000000000000E+00   1.34017093996391E-15   5.12534855839755E-23
      3.95183281345190E-09   3.95183415362289E-09  -8.89749003919730E-19  -2.04816395038499E-01  -2.04816395038541E-01
      0.00000000000000E+00   0.00000000000000E+00   4.20179447449687E-11   0.00000000000000E+00   4.20179447449687E-11
      3.88739057482513E-18  -2.04816427823647E-01  -2.03558149756472E-01   0.00000000000000E+00   9.30595212661209E-14
     -9.70557538174886E-23  -3.99394515788904E-09  -3.99385209836787E-09  -2.99764157090540E-18
      1.65831867338736E-09
      0.00000000000000E+00  -3.95327302362357E-12   0.00000000000000E+00   1.33186434061136E-15   5.20508154117975E-23
      3.95323235780800E-09   3.95323368967239E-09  -8.89863144929614E-19  -2.04676482851809E-01  -2.04676482851850E-01
      0.00000000000000E+00   0.00000000000000E+00   4.13347136988419E-11   0.00000000000000E+00   4.13347136988419E-11
      3.88945731051007E-18  -2.04676521318562E-01  -2.03418017527033E-01   0.00000000000000E+00   9.16587367506062E-14
     -9.70350534825871E-23  -3.99466006210789E-09  -3.99456840337123E-09  -2.99959416558046E-18
      1.70831867338737E-09
      0.00000000000000E+00  -3.95465069468169E-12   0.00000000000000E+00   1.29408310128779E-15   5.28412020184288E-23
      3.95460921739274E-09   3.95461051147590E-09  -8.89974073729833E-19  -2.04538951436670E-01  -2.04538951436711E-01
      0.00000000000000E+00   0.00000000000000E+00   4.06668258187432E-11   0.00000000000000E+00   4.06668258187432E-11
      3.89149065180101E-18  -2.04538980660725E-01  -2.03280253458463E-01   0.00000000000000E+00   9.03224536974540E-14
     -9.70146350880959E-23  -3.99536765974822E-09  -3.99527733729462E-09  -3.00151657807118E-18
      1.75831867338737E-09
      0.00000000000000E+00  -3.95593652100259E-12   0.00000000000000E+00   1.28958329388973E-15   5.36247053091448E-23
      3.95596414567637E-09   3.95596543525972E-09  -8.90082029711267E-19  -2.04403743517082E-01  -2.04403743517122E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00135969923174E-11   0.00000000000000E+00   4.00135969923174E-11
      3.89349133165063E-18  -2.04403740412204E-01  -2.03144792090684E-01   0.00000000000000E+00   8.89739449472683E-14
     -9.69944938626253E-23  -3.99606800619692E-09  -3.99597903225207E-09  -3.00340930193936E-18
      1.80831867338737E-09
      0.00000000000000E+00  -3.95731419206070E-12   0.00000000000000E+00   1.25079844975594E-15   5.44013685712813E-23
      3.95729740142129E-09   3.95729865221980E-09  -8.90187233618788E-19  -2.04270801491793E-01  -2.04270801491832E-01
      0.00000000000000E+00   0.00000000000000E+00   3.93746275383376E-11   0.00000000000000E+00   3.93746275383376E-11
      3.89546006302754E-18  -2.04270739622127E-01  -2.03011572517713E-01   0.00000000000000E+00   8.76897854013554E-14
     -9.69746254364403E-23  -3.99676096954346E-09  -3.99667327975816E-09  -3.00527282940876E-18
      1.85831867338737E-09
      0.00000000000000E+00  -3.95860001838161E-12   0.00000000000000E+00   1.24633107033349E-15   5.51712177826504E-23
      3.95860847466251E-09   3.95860972099364E-09  -8.90289896358965E-19  -2.04140064312654E-01  -2.04140064312693E-01
      0.00000000000000E+00   0.00000000000000E+00   3.87499456900786E-11   0.00000000000000E+00   3.87499456900786E-11
      3.89739756031205E-18  -2.04139924631247E-01  -2.02880541231975E-01   0.00000000000000E+00   8.63829661773250E-14
     -9.69550268302230E-23  -3.99744604964977E-09  -3.99735966668369E-09  -3.00710766395308E-18
      1.90831867338736E-09
      0.00000000000000E+00  -3.95997768943972E-12   0.00000000000000E+00   1.20566233112906E-15   5.59342529453987E-23
      3.95989602099070E-09   3.95989722665309E-09  -8.90390224491339E-19  -2.04011465756834E-01  -2.04011465756872E-01
      0.00000000000000E+00   0.00000000000000E+00   3.81398662679232E-11   0.00000000000000E+00   3.81398662679232E-11
      3.89930455362544E-18  -2.04011252831658E-01  -2.02751655950509E-01   0.00000000000000E+00   8.51264226104669E-14
     -9.69356966735059E-23  -3.99812221934352E-09  -3.99803709292101E-09  -3.00891432913410E-18
      1.95831867338736E-09
      0.00000000000000E+00  -3.96117167102342E-12   0.00000000000000E+00   1.19831617960336E-15   5.66904558897873E-23
      3.96115809276088E-09   3.96115929107711E-09  -8.90488420697622E-19  -2.03884934965534E-01  -2.03884934965571E-01
      0.00000000000000E+00   0.00000000000000E+00   3.75448227793383E-11   0.00000000000000E+00   3.75448227793383E-11
      3.90118179476441E-18  -2.03884695083476E-01  -2.02624888010348E-01   0.00000000000000E+00   8.38296971414760E-14
     -9.69166357477073E-23  -3.99878794355350E-09  -3.99870411385645E-09  -3.01069337406679E-18
      2.00831867338737E-09
      0.00000000000000E+00  -3.96245749734433E-12   0.00000000000000E+00   1.15382663297508E-15   5.74398022554869E-23
      3.96239292360729E-09   3.96239407743398E-09  -8.90584674025418E-19  -2.03760401746163E-01  -2.03760401746200E-01
      0.00000000000000E+00   0.00000000000000E+00   3.69648250017527E-11   0.00000000000000E+00   3.69648250017527E-11
      3.90303003601450E-18  -2.03760235177797E-01  -2.02500221756245E-01   0.00000000000000E+00   8.25680024022361E-14
     -9.68978460586832E-23  -3.99944147043805E-09  -3.99935890243575E-09  -3.01244536198908E-18
      2.05831867338737E-09
      0.00000000000000E+00  -3.96365147892802E-12   0.00000000000000E+00   1.14529411910675E-15   5.81822937985719E-23
      3.96360022386858E-09   3.96360136916276E-09  -8.90679139282012E-19  -2.03637806987175E-01  -2.03637806987211E-01
      0.00000000000000E+00   0.00000000000000E+00   3.63988835309819E-11   0.00000000000000E+00   3.63988835309819E-11
      3.90484998019105E-18  -2.03637863049542E-01  -2.02377647525353E-01   0.00000000000000E+00   8.12606534497927E-14
     -9.68793293565679E-23  -4.00008151334710E-09  -4.00000025269374E-09  -3.01417084090904E-18
      2.10831867338737E-09
      0.00000000000000E+00  -3.96484546051172E-12   0.00000000000000E+00   1.10232585031314E-15   5.89179998062061E-23
      3.96478289851664E-09   3.96478400084255E-09  -8.90771905992887E-19  -2.03517118081715E-01  -2.03517118081750E-01
      0.00000000000000E+00   0.00000000000000E+00   3.58442856435673E-11   0.00000000000000E+00   3.58442856435673E-11
      3.90664219447322E-18  -2.03517560653465E-01  -2.02257147211146E-01   0.00000000000000E+00   8.00079108051627E-14
     -9.68610837401663E-23  -4.00070829439681E-09  -4.00062828648610E-09  -3.01587028848034E-18
      2.15831867338737E-09
      0.00000000000000E+00  -3.96594759735821E-12   0.00000000000000E+00   1.10188872165907E-15   5.96470997060109E-23
      3.96594850682130E-09   3.96594960871008E-09  -8.90862966983102E-19  -2.03398344627577E-01  -2.03398344627612E-01
      0.00000000000000E+00   0.00000000000000E+00   3.52963444903139E-11   0.00000000000000E+00   3.52963444903139E-11
      3.90840701169774E-18  -2.03399280309218E-01  -2.02138672226566E-01   0.00000000000000E+00   7.87602133390413E-14
     -9.68431000154676E-23  -4.00132471341361E-09  -4.00124595320036E-09  -3.01754404471464E-18
      2.20831867338737E-09
      0.00000000000000E+00  -3.96714157894191E-12   0.00000000000000E+00   1.08044112102880E-15   6.03699070376947E-23
      3.96710967602409E-09   3.96711075646528E-09  -8.90952201161737E-19  -2.03281547539497E-01  -2.03281547539531E-01
      0.00000000000000E+00   0.00000000000000E+00   3.47487760512745E-11   0.00000000000000E+00   3.47487760512745E-11
      3.91014445050030E-18  -2.03282921167494E-01  -2.02022119722530E-01   0.00000000000000E+00   7.76459985159293E-14
     -9.68253579450127E-23  -4.00193717851502E-09  -4.00185953251660E-09  -3.01919224933857E-18
      2.25831867338737E-09
      0.00000000000000E+00  -3.96833556052561E-12   0.00000000000000E+00   1.09862981092568E-15   6.10868399946892E-23
      3.96828214292510E-09   3.96828324155497E-09  -8.91039394760792E-19  -2.03166829963179E-01  -2.03166829963213E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41954362417282E-11   0.00000000000000E+00   3.41954362417282E-11
      3.91185422231239E-18  -2.03168313033220E-01  -2.01907316480440E-01   0.00000000000000E+00   7.66503552691025E-14
     -9.68078257006177E-23  -4.00255532815188E-09  -4.00247867779671E-09  -3.02081482755160E-18
      2.30831867338737E-09
      0.00000000000000E+00  -3.96943769737210E-12   0.00000000000000E+00   1.11643451884295E-15   6.17983120856118E-23
      3.96947959656024E-09   3.96948071299482E-09  -8.91124321762821E-19  -2.03054299997848E-01  -2.03054299997882E-01
      0.00000000000000E+00   0.00000000000000E+00   3.36333184249691E-11   0.00000000000000E+00   3.36333184249691E-11
      3.91353588823364E-18  -2.03055223460258E-01  -2.01794026689466E-01   0.00000000000000E+00   7.58520832043889E-14
     -9.67904641516725E-23  -4.00318988350283E-09  -4.00311403141973E-09  -3.02241156647082E-18
      2.35831867338737E-09
      0.00000000000000E+00  -3.97072352369300E-12   0.00000000000000E+00   1.14239192022007E-15   6.25045327309165E-23
      3.97070500748731E-09   3.97070614987929E-09  -8.91206896072773E-19  -2.02943998900495E-01  -2.02943998900528E-01
      0.00000000000000E+00   0.00000000000000E+00   3.30667155617828E-11   0.00000000000000E+00   3.30667155617828E-11
      3.91518922401173E-18  -2.02943403201643E-01  -2.01681998817256E-01   0.00000000000000E+00   7.52013264757938E-14
     -9.67732393208231E-23  -4.00384806676748E-09  -4.00377286544110E-09  -3.02398232793895E-18
      2.40831867338737E-09
      0.00000000000000E+00  -3.97191750527670E-12   0.00000000000000E+00   1.15567504450208E-15   6.32052221185730E-23
      3.97194006063981E-09   3.97194121631492E-09  -8.91287377584425E-19  -2.02835802879207E-01  -2.02835802879239E-01
      0.00000000000000E+00   0.00000000000000E+00   3.25110725045118E-11   0.00000000000000E+00   3.25110725045118E-11
      3.91681477763695E-18  -2.02832680799808E-01  -2.01571062317286E-01   0.00000000000000E+00   7.45886982157294E-14
     -9.67561423452417E-23  -4.00452687751757E-09  -4.00445228881945E-09  -3.02552740005253E-18
      2.45831867338737E-09
      0.00000000000000E+00  -3.97311148686040E-12   0.00000000000000E+00   1.11609491186753E-15   6.38993580573246E-23
      3.97313631250056E-09   3.97313742859553E-09  -8.91366575100615E-19  -2.02729325179063E-01  -2.02729325179095E-01
      0.00000000000000E+00   0.00000000000000E+00   3.19945966881273E-11   0.00000000000000E+00   3.19945966881273E-11
      3.91841450747136E-18  -2.02723099510153E-01  -2.01461266829653E-01   0.00000000000000E+00   7.37949620687992E-14
     -9.67392144182875E-23  -4.00520582024562E-09  -4.00513202528365E-09  -3.02704793237074E-18
      2.50831867338737E-09
      0.00000000000000E+00  -3.97430546844410E-12   0.00000000000000E+00   1.00764592122955E-15   6.45850483576926E-23
      3.97421432904603E-09   3.97421533669201E-09  -8.91445937140328E-19  -2.02623870163361E-01  -2.02623870163393E-01
      0.00000000000000E+00   0.00000000000000E+00   3.15545279217011E-11   0.00000000000000E+00   3.15545279217011E-11
      3.91999223386745E-18  -2.02615062375231E-01  -2.01353028700237E-01   0.00000000000000E+00   7.24921787265974E-14
     -9.67225669416732E-23  -4.00584235679232E-09  -4.00576986461369E-09  -3.02854629672712E-18
      2.55831867338737E-09
      0.00000000000000E+00  -3.97513207107897E-12   0.00000000000000E+00   8.69076745526911E-16   6.52597842203801E-23
      3.97507791542972E-09   3.97507878450654E-09  -8.91527389871788E-19  -2.02518506746488E-01  -2.02518506746519E-01
      0.00000000000000E+00   0.00000000000000E+00   3.12257189106905E-11   0.00000000000000E+00   3.12257189106905E-11
      3.92155351981298E-18  -2.02509418525850E-01  -2.01247216391329E-01   0.00000000000000E+00   7.02961447825514E-14
     -9.67063835300271E-23  -4.00637479956191E-09  -4.00630450341722E-09  -3.03002612994119E-18
      2.60831867338737E-09
      0.00000000000000E+00  -3.97568313950221E-12   0.00000000000000E+00   5.46031629054976E-16   6.59212190718281E-23
      3.97564938406740E-09   3.97564993009910E-09  -8.91612786180213E-19  -2.02412327110189E-01  -2.02412327110220E-01
      0.00000000000000E+00   0.00000000000000E+00   3.10204239915522E-11   0.00000000000000E+00   3.10204239915522E-11
      3.92310454101256E-18  -2.02407394135512E-01  -2.01145076686218E-01   0.00000000000000E+00   6.72181647085160E-14
     -9.66908861004800E-23  -4.00673757225529E-09  -4.00667035409068E-09  -3.03149175483235E-18
      2.65831867338737E-09
      0.00000000000000E+00  -3.97595867371383E-12   0.00000000000000E+00   6.11976920684764E-16   6.65685271056116E-23
      3.97592575231175E-09   3.97592636428873E-09  -8.91702910737774E-19  -2.02304919029099E-01  -2.02304919029130E-01
      0.00000000000000E+00   0.00000000000000E+00   3.09022968258539E-11   0.00000000000000E+00   3.09022968258539E-11
      3.92464965585385E-18  -2.02310271003763E-01  -2.01047903752095E-01   0.00000000000000E+00   6.29374249740841E-14
     -9.66762522685177E-23  -4.00689159853946E-09  -4.00682866111459E-09  -3.03294674511607E-18
      2.70831867338737E-09
      0.00000000000000E+00  -3.97605051845104E-12   0.00000000000000E+00   9.04705977060602E-17   6.72042613650130E-23
      3.97604506144807E-09   3.97604515191874E-09  -8.91796181822715E-19  -2.02196987585031E-01  -2.02196987585062E-01
      0.00000000000000E+00   0.00000000000000E+00   3.07630557407325E-11   0.00000000000000E+00   3.07630557407325E-11
      3.92618780864089E-18  -2.02218756593531E-01  -2.00956395633107E-01   0.00000000000000E+00   5.94111151188893E-14
     -9.66624838960986E-23  -4.00686761877447E-09  -4.00680820765945E-09  -3.03439162681817E-18
      2.75831867338737E-09
      0.00000000000000E+00  -3.97632605266266E-12   0.00000000000000E+00   2.19430957541236E-16   6.78359030336330E-23
      3.97633704032913E-09   3.97633725976016E-09  -8.91887431558752E-19  -2.02090947183995E-01  -2.02090947184025E-01
      0.00000000000000E+00   0.00000000000000E+00   3.04158509789522E-11   0.00000000000000E+00   3.04158509789522E-11
      3.92770860118983E-18  -2.02132112663481E-01  -2.00869769011876E-01   0.00000000000000E+00   5.70364117748142E-14
     -9.66492527174675E-23  -4.00681014715080E-09  -4.00675311073912E-09  -3.03582116963108E-18
      2.80831867338737E-09
      0.00000000000000E+00  -3.97724450003474E-12   0.00000000000000E+00   9.75416921935602E-16   6.84764290571533E-23
      3.97731944738292E-09   3.97732042279991E-09  -8.91967495756063E-19  -2.01991136140719E-01  -2.01991136140748E-01
      0.00000000000000E+00   0.00000000000000E+00   2.96236101125851E-11   0.00000000000000E+00   2.96236101125851E-11
      3.92918978169546E-18  -2.02047268944365E-01  -2.00784865129757E-01   0.00000000000000E+00   5.80307499708501E-14
     -9.66357833247333E-23  -4.00700206366236E-09  -4.00694403291249E-09  -3.03722228593940E-18
      2.85831867338737E-09
      0.00000000000000E+00  -3.97963246320213E-12   0.00000000000000E+00   2.25869485943718E-15   6.91423342531953E-23
      3.97959369730633E-09   3.97959595600126E-09  -8.92024501596749E-19  -2.01903228382426E-01  -2.01903228382454E-01
      0.00000000000000E+00   0.00000000000000E+00   2.81778154711201E-11   0.00000000000000E+00   2.81778154711201E-11
      3.93059867246902E-18  -2.01958376053641E-01  -2.00695710792440E-01   0.00000000000000E+00   6.45282960787027E-14
     -9.66208635125002E-23  -4.00783829976839E-09  -4.00777377147241E-09  -3.03857417087227E-18
      2.88331867338737E-09
      0.00000000000000E+00  -3.98110197899745E-12   0.00000000000000E+00  -2.23844791597727E-15   6.94841007330508E-23
      3.98111109590969E-09   3.98110885746185E-09  -8.92045797268626E-19  -2.01862944568819E-01  -2.01862944568846E-01
      0.00000000000000E+00   0.00000000000000E+00   2.72805109898638E-11   0.00000000000000E+00   2.72805109898638E-11
      3.93128068524376E-18  -2.01912010433110E-01  -2.00649149549455E-01   0.00000000000000E+00   7.46027358042398E-14
     -9.66141029847957E-23  -4.00846397118741E-09  -4.00838936845170E-09  -3.03923488797514E-18
      2.89175617338737E-09
      0.00000000000000E+00  -3.98165304742070E-12   0.00000000000000E+00   3.41242178844628E-15   6.96006468108000E-23
      3.98169884723544E-09   3.98170225965729E-09  -8.92051981697200E-19  -2.01849853211841E-01  -2.01849853211868E-01
      0.00000000000000E+00   0.00000000000000E+00   2.69341025222886E-11   0.00000000000000E+00   2.69341025222886E-11
      3.93150794173380E-18  -2.01896128311213E-01  -2.00633191249441E-01   0.00000000000000E+00   7.11877673239920E-14
     -9.66100946585992E-23  -4.00870754994671E-09  -4.00863636217948E-09  -3.03945596003659E-18
      2.90314679838737E-09
      0.00000000000000E+00  -3.98257149479278E-12   0.00000000000000E+00   3.67294402502902E-15   6.97601411721253E-23
      3.98255027753735E-09   3.98255395048144E-09  -8.92058632554214E-19  -2.01833038658938E-01  -2.01833038658964E-01
      0.00000000000000E+00   0.00000000000000E+00   2.64622070204658E-11   0.00000000000000E+00   2.64622070204658E-11
      3.93180936281064E-18  -2.01874104688801E-01  -2.00611047965033E-01   0.00000000000000E+00   7.39330352635870E-14
     -9.66062246272214E-23  -4.00909009053712E-09  -4.00901615750195E-09  -3.03975073025643E-18
      2.91852414213737E-09
      0.00000000000000E+00  -3.98385732111368E-12   0.00000000000000E+00   4.27559139769774E-15   6.99796835321590E-23
      3.98388453331704E-09   3.98388880890851E-09  -8.92064103958724E-19  -2.01812106007674E-01  -2.01812106007699E-01
      0.00000000000000E+00   0.00000000000000E+00   2.57460715368102E-11   0.00000000000000E+00   2.57460715368102E-11
      3.93220526900287E-18  -2.01843071363567E-01  -2.00579819699252E-01   0.00000000000000E+00   7.83295661578398E-14
     -9.66006884002427E-23  -4.00971321001147E-09  -4.00963488044540E-09  -3.04014116504415E-18
      2.93928355619987E-09
      0.00000000000000E+00  -3.98606159480666E-12   0.00000000000000E+00   5.18028014415292E-15   7.02849454937104E-23
      3.98605861129236E-09   3.98606379157257E-09  -8.92064181502931E-19  -2.01787511368461E-01  -2.01787511368485E-01
      0.00000000000000E+00   0.00000000000000E+00   2.46350235730368E-11   0.00000000000000E+00   2.46350235730368E-11
      3.93271667765766E-18  -2.01798122390562E-01  -2.00534535517410E-01   0.00000000000000E+00   8.55346511518253E-14
     -9.65925445387643E-23  -4.01078434979665E-09  -4.01069881514560E-09  -3.04065249615474E-18
      2.96730876518424E-09
      0.00000000000000E+00  -3.98973538429496E-12   0.00000000000000E+00   6.57975549302714E-15   7.07148906838503E-23
      3.98969257965265E-09   3.98969915940821E-09  -8.92049604230323E-19  -2.01761666289255E-01  -2.01761666289278E-01
      0.00000000000000E+00   0.00000000000000E+00   2.29199535350981E-11   0.00000000000000E+00   2.29199535350981E-11
      3.93335901414540E-18  -2.01730054042979E-01  -2.00465862199159E-01   0.00000000000000E+00   9.72215953737654E-14
     -9.65800641104074E-23  -4.01271633453856E-09  -4.01261911294328E-09  -3.04130940991508E-18
      3.00514279731315E-09
      0.00000000000000E+00  -3.99561344747624E-12   0.00000000000000E+00   7.80737021852089E-15   7.13244314111063E-23
      3.99561147700710E-09   3.99561928437739E-09  -8.92004912941306E-19  -2.01739462375038E-01  -2.01739462375058E-01
      0.00000000000000E+00   0.00000000000000E+00   2.04923233103816E-11   0.00000000000000E+00   2.04923233103816E-11
      3.93413432136392E-18  -2.01620915234738E-01  -2.00355622996167E-01   0.00000000000000E+00   1.15286228130918E-13
     -9.65601709298326E-23  -4.01622689391582E-09  -4.01611160768779E-09  -3.04212940842262E-18
      3.05514279731315E-09
      0.00000000000000E+00  -4.00314471592726E-12   0.00000000000000E+00   7.54896353231641E-15   7.21359132767617E-23
      4.00317064248163E-09   4.00317819144523E-09  -8.91931896468457E-19  -2.01718398426332E-01  -2.01718398426350E-01
      0.00000000000000E+00   0.00000000000000E+00   1.83644898250341E-11   0.00000000000000E+00   1.83644898250341E-11
      3.93505254585517E-18  -2.01446599050036E-01  -2.00179595667122E-01   0.00000000000000E+00   1.32628326160690E-13
     -9.65299780796860E-23  -4.02167530959630E-09  -4.02154268127023E-09  -3.04312064938672E-18
      3.10514279731315E-09
      0.00000000000000E+00  -4.00681850541556E-12   0.00000000000000E+00   3.72751956364283E-15   7.28630225196745E-23
      4.00681299047480E-09   4.00681671799443E-09  -8.91906904262521E-19  -2.01676274378698E-01  -2.01676274378717E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91319743069432E-11   0.00000000000000E+00   1.91319743069432E-11
      3.93600914457052E-18  -2.01258582378117E-01  -1.99990190810801E-01   0.00000000000000E+00   1.28610522059546E-13
     -9.65006355436093E-23  -4.02607730282336E-09  -4.02594869230140E-09  -3.04410224030800E-18
      3.15514279731315E-09
      0.00000000000000E+00  -4.00176704486915E-12   0.00000000000000E+00  -4.41447869264128E-15   7.33757415113335E-23
      4.00173509798107E-09   4.00173068350245E-09  -8.92020178512798E-19  -2.01569990911945E-01  -2.01569990911970E-01
      0.00000000000000E+00   0.00000000000000E+00   2.46957211059957E-11   0.00000000000000E+00   2.46957211059957E-11
      3.93724393062582E-18  -2.01095284099432E-01  -1.99826742114959E-01   0.00000000000000E+00   8.60990127387893E-14
     -9.64806775631722E-23  -4.02651250362107E-09  -4.02642640460843E-09  -3.04522375211302E-18
      3.20514279731315E-09
      0.00000000000000E+00  -3.98348994216485E-12   0.00000000000000E+00  -1.64190149787939E-14   7.35385804050770E-23
      3.98347441406596E-09   3.98345799505105E-09  -8.92368694000695E-19  -2.01352729840691E-01  -2.01352729840727E-01
      0.00000000000000E+00   0.00000000000000E+00   3.61431106603381E-11   0.00000000000000E+00   3.61431106603381E-11
      3.93905108615884E-18  -2.01016247433641E-01  -1.99749856073194E-01   0.00000000000000E+00  -6.82482379548453E-15
     -9.64813040649163E-23  -4.01959428088752E-09  -4.01960110571141E-09  -3.04668239215814E-18
      3.25514279731315E-09
      0.00000000000000E+00  -3.95042583677014E-12   0.00000000000000E+00  -1.28692769228056E-14   7.32773610214541E-23
      3.95053022810291E-09   3.95051735882607E-09  -8.93012351150303E-19  -2.00994689156981E-01  -2.00994689157034E-01
      0.00000000000000E+00   0.00000000000000E+00   5.24642842224519E-11   0.00000000000000E+00   5.24642842224519E-11
      3.94167430036996E-18  -2.01089315211023E-01  -1.99828165578950E-01   0.00000000000000E+00  -1.63263817443746E-13
     -9.65128950767952E-23  -4.00281837923098E-09  -4.00298164304852E-09  -3.04866194921966E-18
      3.30514279731315E-09
      0.00000000000000E+00  -3.90762618923143E-12   0.00000000000000E+00  -3.77398879797035E-14   7.26707132945266E-23
      3.90771128531303E-09   3.90767354542513E-09  -8.93910845686259E-19  -2.00513299930132E-01  -2.00513299930202E-01
      0.00000000000000E+00   0.00000000000000E+00   6.92325545667418E-11   0.00000000000000E+00   6.92325545667418E-11
      3.94513592809830E-18  -2.01362242389619E-01  -2.00109303277666E-01   0.00000000000000E+00  -3.01976523556371E-13
     -9.65788546825800E-23  -3.97660412346823E-09  -3.97690609999188E-09  -3.05122508241204E-18
      3.35514279731315E-09
      0.00000000000000E+00  -3.86895955486706E-12   0.00000000000000E+00  -1.52167315659118E-14   7.20419149134937E-23
      3.86898880125039E-09   3.86897358451890E-09  -8.94854562699560E-19  -2.00006659791340E-01  -2.00006659791418E-01
      0.00000000000000E+00   0.00000000000000E+00   7.79068749441493E-11   0.00000000000000E+00   7.79068749441493E-11
      3.94903127184550E-18  -2.01822031470839E-01  -2.00578558010750E-01   0.00000000000000E+00  -4.24350834969693E-13
     -9.66677021771164E-23  -3.94645610862801E-09  -3.94688045946308E-09  -3.05417670914595E-18
      3.40514279731315E-09
      0.00000000000000E+00  -3.85803003113937E-12   0.00000000000000E+00  -6.30436881285070E-15   7.19981293640335E-23
      3.85807504320325E-09   3.85806873883451E-09  -8.95426792172634E-19  -1.99672528711260E-01  -1.99672528711327E-01
      0.00000000000000E+00   0.00000000000000E+00   6.68417609431651E-11   0.00000000000000E+00   6.68417609431651E-11
      3.95237335989266E-18  -2.02350502521217E-01  -2.01113945102529E-01   0.00000000000000E+00  -3.61561968521300E-13
     -9.67468344344353E-23  -3.92454893780902E-09  -3.92491049977764E-09  -3.05694656772003E-18
      3.45514279731315E-09
      0.00000000000000E+00  -3.90450346816638E-12   0.00000000000000E+00   4.61485974261282E-14   7.33678236453890E-23
      3.90442559671506E-09   3.90447174531256E-09  -8.95046690997216E-19  -1.99788798138000E-01  -1.99788798138025E-01
      0.00000000000000E+00   0.00000000000000E+00   2.48987234586885E-11   0.00000000000000E+00   2.48987234586885E-11
      3.95361829606560E-18  -2.02697717208858E-01  -2.01459753465508E-01   0.00000000000000E+00  -6.24541630026129E-14
     -9.67603154098199E-23  -3.92930801460813E-09  -3.92937046877123E-09  -3.05857160506838E-18
      3.50514279731315E-09
      0.00000000000000E+00  -4.03391270289178E-12   0.00000000000000E+00   2.67325228338394E-13   7.69843462338369E-23
      4.03379989935884E-09   4.03406722458726E-09  -8.93144830692237E-19  -2.00630462616983E-01  -2.00630462616931E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.24641604740280E-11   0.00000000000000E+00  -5.24641604740280E-11
      3.95099508804189E-18  -2.02489939316695E-01  -2.01235563265933E-01   0.00000000000000E+00   3.98933826633797E-13
     -9.66401941658115E-23  -3.98200199793976E-09  -3.98160306411323E-09  -3.05785025734965E-18
      3.55514279731315E-09
      0.00000000000000E+00  -4.25305424586894E-12   0.00000000000000E+00   2.19841989021928E-13   8.32774179296026E-23
      4.25285547152869E-09   4.25307531351779E-09  -8.89479937103009E-19  -2.02319178917462E-01  -2.02319178917306E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55866164743336E-10   0.00000000000000E+00  -1.55866164743336E-10
      3.94320177980473E-18  -2.01297409171498E-01  -2.00006567728731E-01   0.00000000000000E+00   1.38704903550910E-12
     -9.63276760839007E-23  -4.09859619780985E-09  -4.09720914877443E-09  -3.05372184270172E-18
      3.60514279731315E-09
      0.00000000000000E+00  -4.52996612854963E-12   0.00000000000000E+00   2.78059267110723E-13   9.16947964794990E-23
      4.52968585274040E-09   4.52996391200760E-09  -8.84487923509301E-19  -2.04657611457528E-01  -2.04657611457271E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.57058418443192E-10   0.00000000000000E+00  -2.57058418443192E-10
      3.93034885888257E-18  -1.98797062200659E-01  -1.97450866438052E-01   0.00000000000000E+00   2.26573993165226E-12
     -9.58092226546642E-23  -4.27517123349599E-09  -4.27290549356443E-09  -3.04586093537327E-18
      3.65514279731315E-09
      0.00000000000000E+00  -4.77445681899607E-12   0.00000000000000E+00   2.46063562690161E-13   1.00014798324823E-22
      4.77419262806790E-09   4.77443869163069E-09  -8.79544640231385E-19  -2.07004696523885E-01  -2.07004696523578E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.06821993937735E-10   0.00000000000000E+00  -3.06821993937735E-10
      3.91500775918568E-18  -1.95052466481590E-01  -1.93644924788279E-01   0.00000000000000E+00   2.78930561064182E-12
     -9.51568943671253E-23  -4.47040600330353E-09  -4.46761669769299E-09  -3.03546311895430E-18
      3.70514279731315E-09
      0.00000000000000E+00  -4.82836967973689E-12   0.00000000000000E+00   5.56905198426989E-14   1.03924564391529E-22
      4.82828914496828E-09   4.82834483548823E-09  -8.77048284552373E-19  -2.08230521544915E-01  -2.08230521544679E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.36262111991381E-10   0.00000000000000E+00  -2.36262111991381E-10
      3.90319465358611E-18  -1.90896876509272E-01  -1.89450119019149E-01   0.00000000000000E+00   2.44370555676855E-12
     -9.45734933436426E-23  -4.59452642905353E-09  -4.59208272349685E-09  -3.02614636903374E-18
      3.75514279731315E-09
      0.00000000000000E+00  -4.49093211523644E-12   0.00000000000000E+00  -3.35834038946008E-13   9.76397316425766E-23
      4.49124304709419E-09   4.49090721305534E-09  -8.80340711353420E-19  -2.06736790947862E-01  -2.06736790947895E-01
      0.00000000000000E+00   0.00000000000000E+00   3.28539485712810E-11   0.00000000000000E+00   3.28539485712810E-11
      3.90483735101468E-18  -1.88199129160658E-01  -1.86773894167414E-01   0.00000000000000E+00   6.48702585162853E-13
     -9.44185893561325E-23  -4.52440986421170E-09  -4.52376116162663E-09  -3.02449663966126E-18
      3.80514279731315E-09
      0.00000000000000E+00  -3.62373410652297E-12   0.00000000000000E+00  -8.67526496104926E-13   7.67931369157938E-23
      3.62459655029727E-09   3.62372902380124E-09  -8.93245562201676E-19  -2.00651776307075E-01  -2.00651776307617E-01
      0.00000000000000E+00   0.00000000000000E+00   5.42775011424146E-10   0.00000000000000E+00   5.42775011424146E-10
      3.93197610158588E-18  -1.89453886493274E-01  -1.88141204949613E-01   0.00000000000000E+00  -3.07947514025306E-12
     -9.51540193823164E-23  -4.16342456008501E-09  -4.16650403522536E-09  -3.03873053938421E-18
      3.85514279731315E-09
      0.00000000000000E+00  -2.32844777768522E-12   0.00000000000000E+00  -1.22870350458000E-12   4.33045272607379E-23
      2.32969705673519E-09   2.32846835323066E-09  -9.18687418802650E-19  -1.88464274937726E-01  -1.88464274938940E-01
      0.00000000000000E+00   0.00000000000000E+00   1.21391963200121E-09   0.00000000000000E+00   1.21391963200121E-09
      3.99267208318594E-18  -1.96224311318600E-01  -1.95108282216587E-01   0.00000000000000E+00  -8.82786290152537E-12
     -9.71321356091402E-23  -3.53356012233024E-09  -3.54238798523187E-09  -3.07398466438329E-18
      3.90514279731315E-09
      0.00000000000000E+00  -1.01708861983615E-12   0.00000000000000E+00  -1.33632195163092E-12   7.15648870103564E-24
      1.01841496616591E-09   1.01707864421429E-09  -9.56041801660167E-19  -1.70283656003878E-01  -1.70283656005683E-01
      0.00000000000000E+00   0.00000000000000E+00   1.80455793651924E-09   0.00000000000000E+00   1.80455793651924E-09
      4.08289998001191E-18  -2.07471723048535E-01  -2.06582744213194E-01   0.00000000000000E+00  -1.52652782043592E-11
     -1.00266190919748E-22  -2.80637130252905E-09  -2.82163658073351E-09  -3.12685817835174E-18
      3.95514279731315E-09
      0.00000000000000E+00  -1.84791611261544E-13   0.00000000000000E+00  -8.75796190661782E-13  -1.88547280633526E-23
      1.85705308213684E-10   1.84829512023003E-10  -9.97548754479484E-19  -1.49693060666273E-01  -1.49693060668268E-01
      0.00000000000000E+00   0.00000000000000E+00   1.99460923063626E-09   0.00000000000000E+00   1.99460923063626E-09
      4.18263044154372E-18  -2.20274384549605E-01  -2.19587731721121E-01   0.00000000000000E+00  -1.97308775984133E-11
     -1.03888316190128E-22  -2.15970786506075E-09  -2.17943874265926E-09  -3.18508168706423E-18
      4.00514279731315E-09
      0.00000000000000E+00  -6.01583028709300E-14   0.00000000000000E+00  -1.67572294881338E-13  -2.99924628164279E-23
      6.03273732229169E-11   6.01598009280055E-11  -1.02807503777338E-18  -1.34261366727743E-01  -1.34261366729312E-01
      0.00000000000000E+00   0.00000000000000E+00   1.56891720289503E-09   0.00000000000000E+00   1.56891720289503E-09
      4.26107630168847E-18  -2.32472153652115E-01  -2.31958897607920E-01   0.00000000000000E+00  -1.81979586737651E-11
     -1.06940531218578E-22  -1.61087904514919E-09  -1.62907700382307E-09  -3.23300126391509E-18
      4.05514279731315E-09
      0.00000000000000E+00  -5.23606846820110E-13   0.00000000000000E+00   4.49237525555003E-13  -3.09138266039362E-23
      5.23146685384819E-10   5.23595922910343E-10  -1.03391018622209E-18  -1.31244689862813E-01  -1.31244689863449E-01
      0.00000000000000E+00   0.00000000000000E+00   6.35555039119309E-10   0.00000000000000E+00   6.35555039119309E-10
      4.29285405364443E-18  -2.43258680940184E-01  -2.42893485035512E-01   0.00000000000000E+00  -9.42632685009276E-12
     -1.08443533145346E-22  -1.14972463517943E-09  -1.15915096202963E-09  -3.25894386742235E-18
      4.10514279731314E-09
      0.00000000000000E+00  -1.35241375538083E-12   0.00000000000000E+00   8.51931008878492E-13  -2.17741481096665E-23
      1.35164039919387E-09   1.35249233020273E-09  -1.01229703414694E-18  -1.42064317094037E-01  -1.42064317093624E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.13425466627134E-10   0.00000000000000E+00  -4.13425466627134E-10
      4.27218278031308E-18  -2.51865331183953E-01  -2.51569484870196E-01   0.00000000000000E+00   2.26345640694896E-12
     -1.08085556655927E-22  -9.41330319982446E-10  -9.39066863575605E-10  -3.25988574616614E-18
      4.15514279731314E-09
      0.00000000000000E+00  -2.49496228624246E-12   0.00000000000000E+00   1.18379598993386E-12   5.67810355341803E-24
      2.49380199471928E-09   2.49498579070922E-09  -9.71754289151244E-19  -1.61943127043478E-01  -1.61943127042274E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20385270763100E-09   0.00000000000000E+00  -1.20385270763100E-09
      4.21199014493153E-18  -2.56974489814352E-01  -2.56567735064430E-01   0.00000000000000E+00   1.08276093681115E-11
     -1.06325653706580E-22  -1.30196069244625E-09  -1.29113308307824E-09  -3.24023585578029E-18
      4.20514279731314E-09
      0.00000000000000E+00  -4.05283271875653E-12   0.00000000000000E+00   1.59217160526860E-12   5.70376450759548E-23
      4.05129911941398E-09   4.05289129101930E-09  -9.25894771058421E-19  -1.83828231005120E-01  -1.83828231003510E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.61020602473611E-09   0.00000000000000E+00  -1.61020602473611E-09
      4.13147984369472E-18  -2.56196087449587E-01  -2.55426540226526E-01   0.00000000000000E+00   1.46558792075852E-11
     -1.03804856300549E-22  -2.45734114549069E-09  -2.44268526628321E-09  -3.20558507263630E-18
      4.25514279731314E-09
      0.00000000000000E+00  -6.02042252395338E-12   0.00000000000000E+00   1.98375180431575E-12   1.26934329339910E-22
      6.01848418431529E-09   6.02046793611974E-09  -8.84455612720472E-19  -2.03255630405614E-01  -2.03255630403786E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.82820724419357E-09   0.00000000000000E+00  -1.82820724419357E-09
      4.04006948148504E-18  -2.45846803643948E-01  -2.44526047401746E-01   0.00000000000000E+00   1.69075332223079E-11
     -1.00671250772919E-22  -4.20916822514835E-09  -4.19226069192615E-09  -3.15561386876457E-18
      4.30514279731314E-09
      0.00000000000000E+00  -8.29119180667227E-12   0.00000000000000E+00   2.27325666029544E-12   2.06758562043834E-22
      8.28892794868358E-09   8.29120120534408E-09  -8.48889026215835E-19  -2.19948974353746E-01  -2.19948974351632E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.11425140332841E-09   0.00000000000000E+00  -2.11425140332841E-09
      3.93435691131862E-18  -2.23720986099953E-01  -2.21774935579764E-01   0.00000000000000E+00   1.90855399130003E-11
     -9.67153961550190E-23  -6.19603534192856E-09  -6.17694980201566E-09  -3.08546788510279E-18
      4.35514279731314E-09
      0.00000000000000E+00  -1.05818913973652E-11   0.00000000000000E+00   2.28533761860848E-12   2.85933376304085E-22
      1.05796173901519E-08   1.05819027277708E-08  -8.18209842974443E-19  -2.34699232769894E-01  -2.34699232767366E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.52825769884642E-09   0.00000000000000E+00  -2.52825769884642E-09
      3.80794402637630E-18  -1.89016610630625E-01  -1.86479274458673E-01   0.00000000000000E+00   2.03711206191953E-11
     -9.17094886041094E-23  -8.07401614954349E-09  -8.05364502892438E-09  -2.98973418340186E-18
      4.40514279731314E-09
      0.00000000000000E+00  -1.20849305217664E-11   0.00000000000000E+00   1.51153715815348E-12   3.40276206395221E-22
      1.20834936438737E-08   1.20850051810322E-08  -7.94819522259431E-19  -2.46630126834442E-01  -2.46630126831599E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.84223501287567E-09   0.00000000000000E+00  -2.84223501287567E-09
      3.66583227573252E-18  -1.44239138951036E-01  -1.41327133898900E-01   0.00000000000000E+00   1.89716507452149E-11
     -8.61493683322760E-23  -9.26174181890165E-09  -9.24277016815652E-09  -2.87101275347309E-18
      4.45514279731314E-09
      0.00000000000000E+00  -1.25415825551622E-11   0.00000000000000E+00   4.63219795832923E-13   3.57546431131984E-22
      1.25410750399388E-08   1.25415382597350E-08  -7.78147156003953E-19  -2.55974804755354E-01  -2.55974804752374E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.98059586014016E-09   0.00000000000000E+00  -2.98059586014016E-09
      3.51680248272551E-18  -9.70839135653325E-02  -9.40716351380972E-02   0.00000000000000E+00   1.49649438071058E-11
     -7.05250602838873E-23  -9.57590734340185E-09  -9.56094239959482E-09  -2.73865532672156E-18
      4.50514279731314E-09
      0.00000000000000E+00  -1.21555591246790E-11   0.00000000000000E+00  -1.88462552318630E-13   3.48586753897212E-22
      1.21559195796792E-08   1.21557311171273E-08  -7.63277631980561E-19  -2.64645036857953E-01  -2.64645036854967E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.98586093425800E-09   0.00000000000000E+00  -2.98586093425800E-09
      3.36750943601261E-18  -5.70356299785318E-02  -5.41466015056044E-02   0.00000000000000E+00   1.00090711273087E-11
      1.87513487107115E-23  -9.17987925399660E-09  -9.16987018286927E-09  -2.60423180403205E-18
      4.55514279731314E-09
      0.00000000000000E+00  -1.10833636625183E-11   0.00000000000000E+00  -1.04267698449893E-12   3.47269117847704E-22
      1.10844065563051E-08   1.10833638793210E-08  -7.41729726238994E-19  -2.75814039078535E-01  -2.75814039075669E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86554083321901E-09   0.00000000000000E+00  -2.86554083321901E-09
      3.22423239435166E-18  -3.20291724876576E-02  -2.94400308639009E-02   0.00000000000000E+00   6.36657558612386E-12
      1.83681128658285E-22  -8.22418962168826E-09  -8.21782304610195E-09  -2.48250266811267E-18
      4.60514279731314E-09
      0.00000000000000E+00  -1.00859298164445E-11   0.00000000000000E+00  -9.60101242718755E-13   3.62193510820411E-22
      1.00868997572565E-08   1.00859396560142E-08  -7.11967038343727E-19  -2.90055064862573E-01  -2.90055064859811E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.76195160188873E-09   0.00000000000000E+00  -2.76195160188873E-09
      3.08613481425723E-18  -1.97728041038879E-02  -1.74652737093065E-02   0.00000000000000E+00   3.97907026767593E-12
      3.40869631935588E-22  -7.32796712439348E-09  -7.32398805412546E-09  -2.37416777591350E-18
      4.65514279731314E-09
      0.00000000000000E+00  -9.64929993575997E-12   0.00000000000000E+00  -4.10042331788251E-13   3.80022497610846E-22
      9.64967573226021E-09   9.64926568992880E-09  -6.76596360449457E-19  -3.06540180839882E-01  -3.06540180837042E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.84082318577776E-09   0.00000000000000E+00  -2.84082318577776E-09
      2.94409365496834E-18  -1.37869698631380E-02  -1.16418648286694E-02   0.00000000000000E+00   2.79462194871410E-12
      4.58386857432692E-22  -6.81123712610024E-09  -6.80844250415107E-09  -2.26749729451888E-18
      4.70514279731314E-09
      0.00000000000000E+00  -9.44558830863367E-12   0.00000000000000E+00  -1.80804337290035E-13   3.81715563752680E-22
      9.44580236274555E-09   9.44562155840864E-09  -6.40031966146192E-19  -3.23577713950911E-01  -3.23577713948010E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90067601186748E-09   0.00000000000000E+00  -2.90067601186748E-09
      2.79905985437496E-18  -1.05319273253100E-02  -8.46983844288322E-03   0.00000000000000E+00   2.17698653847579E-12
      5.21753268177950E-22  -6.54712253308014E-09  -6.54494554654114E-09  -2.15902788822877E-18
      4.75514279731314E-09
      0.00000000000000E+00  -9.08574062825458E-12   0.00000000000000E+00  -3.38329743950507E-13   3.54474187480339E-22
      9.08610783217088E-09   9.08576950242728E-09  -6.08225975743795E-19  -3.38687401795383E-01  -3.38687401792700E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.68279496577284E-09   0.00000000000000E+00  -2.68279496577284E-09
      2.66492010608632E-18  -8.63795234189742E-03  -6.62059146500298E-03   0.00000000000000E+00   1.63649426016934E-12
      5.17889996856256E-22  -6.40461103091509E-09  -6.40297453665441E-09  -2.05669413034253E-18
      4.80514279731314E-09
      0.00000000000000E+00  -8.41224317031179E-12   0.00000000000000E+00  -6.53496050900424E-13   3.01563986627964E-22
      8.41286684287859E-09   8.41221334682800E-09  -5.86837545941849E-19  -3.49401757701750E-01  -3.49401757699672E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.07799451056187E-09   0.00000000000000E+00  -2.07799451056187E-09
      2.56102038055823E-18  -7.55299953182635E-03  -5.55729948395993E-03   0.00000000000000E+00   1.00093069062862E-12
      4.55553986425356E-22  -6.33521976695725E-09  -6.33421883626617E-09  -1.97418283461638E-18
      4.85514279731314E-09
      0.00000000000000E+00  -7.07581039920507E-12   0.00000000000000E+00  -1.31746771240244E-12   2.27548377595127E-22
      7.07713571316410E-09   7.07581824545193E-09  -5.87087358749488E-19  -3.50888963138374E-01  -3.50888963137639E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34656989903183E-10   0.00000000000000E+00  -7.34656989903183E-10
      2.52428753106307E-18  -7.12938280540520E-03  -5.13149419561243E-03   0.00000000000000E+00  -1.00225236284072E-13
      3.45724173062179E-22  -6.34106103031282E-09  -6.34116125554876E-09  -1.93720017231358E-18
      4.90514279731314E-09
      0.00000000000000E+00  -4.75544495839411E-12   0.00000000000000E+00  -2.30715834319093E-12   1.33826855177116E-22
      4.75770744804142E-09   4.75540028969836E-09  -6.26961113190426E-19  -3.35519648151605E-01  -3.35519648153207E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60156198518941E-09   0.00000000000000E+00   1.60156198518941E-09
      2.60436563032254E-18  -7.67193528159377E-03  -5.66906820164562E-03   0.00000000000000E+00  -2.15980090311622E-12
      1.92705048643542E-22  -6.35480247398481E-09  -6.35696227488773E-09  -1.97740451713211E-18
      4.93014279731314E-09
      0.00000000000000E+00  -3.27297905512742E-12   0.00000000000000E+00  -2.95979080033333E-12   8.54727343650614E-23
      3.27594728828348E-09   3.27298749748324E-09  -6.61083281455777E-19  -3.21720541650598E-01  -3.21720541653651E-01
      0.00000000000000E+00   0.00000000000000E+00   3.05305346387263E-09   0.00000000000000E+00   3.05305346387263E-09
      2.68069196691935E-18  -8.42623564615600E-03  -6.43311073458269E-03   0.00000000000000E+00  -4.00985002465806E-12
      1.11677115988240E-22  -6.32203111133132E-09  -6.32604096135586E-09  -2.01960868546358E-18
      4.96389279731314E-09
      0.00000000000000E+00  -1.45344296630911E-12   0.00000000000000E+00  -2.72296489432685E-12   2.33874487564118E-23
      1.45612463520656E-09   1.45340167031225E-09  -7.29060924572205E-19  -2.93132552055393E-01  -2.93132552060070E-01
      0.00000000000000E+00   0.00000000000000E+00   4.67672467737313E-09   0.00000000000000E+00   4.67672467737313E-09
      2.83853142478070E-18  -1.14890887718274E-02  -9.55769087718280E-03   0.00000000000000E+00  -7.02103648667690E-12
      1.86147987514808E-24  -6.12310531119870E-09  -6.13012634768537E-09  -2.10947050020849E-18
      5.00945529731314E-09
      0.00000000000000E+00   4.02922862129420E-13   0.00000000000000E+00  -2.10899268191619E-12  -2.72717834380405E-23
     -4.00815859835680E-10  -4.02924852517623E-10  -8.39147795119173E-19  -2.43889502348325E-01  -2.43889502354144E-01
      0.00000000000000E+00   0.00000000000000E+00   5.81909040638155E-09   0.00000000000000E+00   5.81909040638155E-09
      3.10366373142146E-18  -2.46330833960294E-02  -2.29266324819424E-02   0.00000000000000E+00  -1.28079728658770E-11
     -7.48784010873074E-23  -5.40335758099798E-09  -5.41616555386393E-09  -2.26451593630229E-18
      5.03445529731314E-09
      0.00000000000000E+00   1.24513910232244E-12   0.00000000000000E+00  -1.78935216786117E-12  -3.77868794260745E-23
     -1.24337915302851E-09  -1.24516850519641E-09  -9.00061705710093E-19  -2.15011488023918E-01  -2.15011488029941E-01
      0.00000000000000E+00   0.00000000000000E+00   6.02249929379582E-09   0.00000000000000E+00   6.02249929379582E-09
      3.25422621376635E-18  -3.61877907326581E-02  -3.46826127283042E-02   0.00000000000000E+00  -1.92792991335693E-11
     -8.32984721826745E-23  -4.75805148946574E-09  -4.77733078859940E-09  -2.35416450805626E-18
      5.06820529731314E-09
      0.00000000000000E+00   1.89236896542388E-12   0.00000000000000E+00  -1.09710035499697E-12  -4.28372543280383E-23
     -1.89131650870169E-09  -1.89241360905673E-09  -9.79303909957182E-19  -1.75660836704527E-01  -1.75660836710510E-01
      0.00000000000000E+00   0.00000000000000E+00   5.98259442685090E-09   0.00000000000000E+00   5.98259442685090E-09
      3.45613877567257E-18  -5.67217675988587E-02  -5.54330857678901E-02   0.00000000000000E+00  -2.75019238003308E-11
     -8.85439673385595E-23  -4.06267889399368E-09  -4.09018081779410E-09  -2.47683486571539E-18
      5.11376779731314E-09
      0.00000000000000E+00   2.04813763972785E-12   0.00000000000000E+00  -3.45006790195914E-13  -4.48094554591978E-23
     -2.04773017566840E-09  -2.04807518245865E-09  -1.07617636402136E-18  -1.24860053495866E-01  -1.24860053501356E-01
      0.00000000000000E+00   0.00000000000000E+00   5.48944920258456E-09   0.00000000000000E+00   5.48944920258456E-09
      3.70625180496533E-18  -8.79328829619985E-02  -8.68486172590677E-02   0.00000000000000E+00  -3.89059085404736E-11
     -9.72009122141891E-23  -3.40246811158532E-09  -3.44137402012590E-09  -2.63007544094397E-18
      5.16376779731314E-09
      0.00000000000000E+00   1.75588768593350E-12   0.00000000000000E+00   1.01448053674977E-13  -4.60677431071990E-23
     -1.75595098617796E-09  -1.75584953812433E-09  -1.16278308085743E-18  -7.67479695227473E-02  -7.67479695273514E-02
      0.00000000000000E+00   0.00000000000000E+00   4.60406369840654E-09   0.00000000000000E+00   4.60406369840654E-09
      3.93645498988566E-18  -1.23149313309971E-01  -1.22251931427893E-01   0.00000000000000E+00  -5.04270316865048E-11
     -1.06559130594458E-22  -2.79778712859560E-09  -2.84821416028221E-09  -2.77367190902823E-18
      5.21376779731314E-09
      0.00000000000000E+00   1.20233945478373E-12   0.00000000000000E+00   3.94894578432460E-13  -4.69898997157052E-23
     -1.20274550762389E-09  -1.20235061304551E-09  -1.22063015998176E-18  -4.30794303159594E-02  -4.30794303193738E-02
      0.00000000000000E+00   0.00000000000000E+00   3.41437300456091E-09   0.00000000000000E+00   3.41437300456091E-09
      4.10717364011370E-18  -1.57848383771142E-01  -1.57151444276467E-01   0.00000000000000E+00  -5.46430937209852E-11
     -1.14792694537620E-22  -2.15737929779433E-09  -2.21202239151543E-09  -2.88654348013195E-18
      5.26376779731314E-09
      0.00000000000000E+00   6.40984420971329E-13   0.00000000000000E+00   4.71290384364207E-13  -4.74458608079717E-23
     -6.41425036330872E-10  -6.40953745946555E-10  -1.25022461089895E-18  -2.53919179877365E-02  -2.53919179899377E-02
      0.00000000000000E+00   0.00000000000000E+00   2.20114527341863E-09   0.00000000000000E+00   2.20114527341863E-09
      4.21723090378463E-18  -1.89081590558773E-01  -1.88590022051725E-01   0.00000000000000E+00  -4.78640941929424E-11
     -1.21142593973430E-22  -1.51232743327902E-09  -1.56019152747208E-09  -2.96700629288568E-18
      5.31376779731314E-09
      0.00000000000000E+00   3.28896003940153E-13   0.00000000000000E+00   2.72151819550988E-13  -4.76362855463589E-23
     -3.29144565649822E-10  -3.28872413830319E-10  -1.26421195927959E-18  -1.70455967670309E-02  -1.70455967684097E-02
      0.00000000000000E+00   0.00000000000000E+00   1.37877182319308E-09   0.00000000000000E+00   1.37877182319308E-09
      4.28616949494429E-18  -2.13112730828228E-01  -2.12781940239382E-01   0.00000000000000E+00  -3.58725977148745E-11
     -1.25521290464386E-22  -1.01402681164776E-09  -1.04989940936276E-09  -3.02195753566469E-18
      5.36376779731314E-09
      0.00000000000000E+00   1.99303079740333E-13   0.00000000000000E+00   1.12561115608108E-13  -4.77206807339587E-23
     -1.99414092896940E-10  -1.99301531781380E-10  -1.27175004742157E-18  -1.27219203750774E-02  -1.27219203759870E-02
      0.00000000000000E+00   0.00000000000000E+00   9.09579327666872E-10   0.00000000000000E+00   9.09579327666872E-10
      4.33164846132763E-18  -2.29689767621842E-01  -2.29465982643436E-01   0.00000000000000E+00  -2.44845684579157E-11
     -1.28356600401685E-22  -6.85793227427430E-10  -7.10277795885474E-10  -3.05989841390607E-18
      5.41376779731314E-09
      0.00000000000000E+00   1.44379926890232E-13   0.00000000000000E+00   4.74001188572861E-14  -4.77607781076892E-23
     -1.44401543650783E-10  -1.44354143531974E-10  -1.27657606328580E-18  -1.01242455302258E-02  -1.01242455308915E-02
      0.00000000000000E+00   0.00000000000000E+00   6.65668868865715E-10   0.00000000000000E+00   6.65668868865715E-10
      4.36493190477092E-18  -2.41487052151045E-01  -2.41322804710068E-01   0.00000000000000E+00  -1.70667497902346E-11
     -1.30265030022055E-22  -5.04247975543395E-10  -5.21314725333760E-10  -3.08835584148512E-18
      5.46376779731314E-09
      0.00000000000000E+00   1.15265145195446E-13   0.00000000000000E+00   2.61281793010209E-14  -4.77774916977512E-23
     -1.15302752737776E-10  -1.15276624558523E-10  -1.27998560688140E-18  -8.41888127915355E-03  -8.41888127968848E-03
      0.00000000000000E+00   0.00000000000000E+00   5.34928259454054E-10   0.00000000000000E+00   5.34928259454054E-10
      4.39167831774362E-18  -2.50645518604696E-01  -2.50513302796473E-01   0.00000000000000E+00  -1.27660354874693E-11
     -1.31656074223846E-22  -4.06885599407908E-10  -4.19651634895509E-10  -3.11169271086222E-18
      5.51376779731314E-09
      0.00000000000000E+00   9.58859056446579E-14   0.00000000000000E+00   1.93026521815228E-14  -4.77788957568419E-23
     -9.58679870290795E-11  -9.58486843769458E-11  -1.28246324871722E-18  -7.28144408460183E-03  -7.28144408506233E-03
      0.00000000000000E+00   0.00000000000000E+00   4.60493022494704E-10   0.00000000000000E+00   4.60493022494704E-10
      4.41470296886836E-18  -2.58459184816507E-01  -2.58344300553260E-01   0.00000000000000E+00  -1.03911228374625E-11
     -1.32764453706804E-22  -3.54253215280167E-10  -3.64644338117762E-10  -3.13223972015114E-18
      5.56376779731314E-09
      0.00000000000000E+00   8.01804555821709E-14   0.00000000000000E+00   1.76748262763983E-14  -4.77682752733270E-23
     -8.02080898821640E-11  -8.01904150559354E-11  -1.28420172451325E-18  -6.55714298069271E-03  -6.55714298112826E-03
      0.00000000000000E+00   0.00000000000000E+00   4.35541680108016E-10   0.00000000000000E+00   4.35541680108016E-10
      4.43648005287376E-18  -2.66410023039539E-01  -2.66298066811800E-01   0.00000000000000E+00  -1.03150596952554E-11
     -1.33841902499970E-22  -3.45036205356679E-10  -3.55351265052069E-10  -3.15227832836050E-18
      5.61376779731314E-09
      0.00000000000000E+00   6.21788870894956E-14   0.00000000000000E+00   2.24285418976830E-14  -4.77434898846927E-23
     -6.22264186302802E-11  -6.22039900884303E-11  -1.28509548597377E-18  -6.23560035435709E-03  -6.23560035483926E-03
      0.00000000000000E+00   0.00000000000000E+00   4.82170433208576E-10   0.00000000000000E+00   4.82170433208576E-10
      4.46058857453419E-18  -2.77190306126135E-01  -2.77057991062723E-01   0.00000000000000E+00  -1.44906364040820E-11
     -1.35320454434731E-22  -4.05475806715983E-10  -4.19966443120201E-10  -3.17549308856041E-18
      5.66376779731314E-09
      0.00000000000000E+00   3.71052738318408E-14   0.00000000000000E+00   3.29806970858378E-14  -4.76984493338539E-23
     -3.71760526167759E-11  -3.71430719197377E-11  -1.28480496246947E-18  -6.52392119676741E-03  -6.52392119728000E-03
      0.00000000000000E+00   0.00000000000000E+00   5.12592888351985E-10   0.00000000000000E+00   5.12592888351985E-10
      4.48621821895178E-18  -2.90662072854769E-01  -2.90512276238061E-01   0.00000000000000E+00  -1.84100797063251E-11
     -1.37157107304278E-22  -4.57039736725749E-10  -4.75449816432211E-10  -3.20141325648231E-18
      5.71376779731314E-09
      0.00000000000000E+00  -3.25130369714645E-14   0.00000000000000E+00   8.76316001123884E-14  -4.75927966976170E-23
      3.24570053387905E-11   3.25446369388553E-11  -1.28113126281894E-18  -8.78059032456498E-03  -8.78059032497665E-03
      0.00000000000000E+00   0.00000000000000E+00   4.11671691871344E-10   0.00000000000000E+00   4.11671691871344E-10
      4.50680180354535E-18  -3.04895585858450E-01  -3.04755630430623E-01   0.00000000000000E+00  -1.71115369092973E-11
     -1.38831194329271E-22  -4.27104791900751E-10  -4.44216328810187E-10  -3.22567054072641E-18
      5.76376779731314E-09
      0.00000000000000E+00  -3.04006080156914E-13   0.00000000000000E+00   3.27311284640087E-13  -4.72471368753365E-23
      3.03656427112186E-10   3.03983738396779E-10  -1.26415762764736E-18  -1.88168822458187E-02  -1.88168822457761E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.25794676159448E-11   0.00000000000000E+00  -4.25794676159448E-11
      4.50467283016456E-18  -3.19659078922542E-01  -3.19576724387264E-01   0.00000000000000E+00  -5.42640058004985E-12
     -1.39376147108696E-22  -2.55977870200676E-10  -2.61404270780865E-10  -3.24051520251720E-18
      5.81376779731313E-09
      0.00000000000000E+00  -8.66646940290222E-13   0.00000000000000E+00   6.85508224557768E-13  -4.64449361046336E-23
      8.65993330691236E-10   8.66678838915747E-10  -1.22011697363398E-18  -4.41335552106190E-02  -4.41335552096695E-02
      0.00000000000000E+00   0.00000000000000E+00  -9.49463982099336E-10   0.00000000000000E+00  -9.49463982099336E-10
      4.45719963105959E-18  -3.35569757184687E-01  -3.35595851523722E-01   0.00000000000000E+00   1.76810878589309E-11
     -1.37711572427571E-22   6.51040553248275E-11   8.27851431836207E-11  -3.23708265742561E-18
      5.86376779731313E-09
      0.00000000000000E+00  -1.25909950237798E-12   0.00000000000000E+00   5.36479957605206E-13  -4.54362336222055E-23
      1.25856142451474E-09   1.25909790447230E-09  -1.15995458795878E-18  -7.73273692593423E-02  -7.73273692578455E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.49679860753973E-09   0.00000000000000E+00  -1.49679860753973E-09
      4.38235970068260E-18  -3.51058513604005E-01  -3.51133422367868E-01   0.00000000000000E+00   2.93887868802810E-11
     -1.34790795701437E-22   2.08311916187252E-10   2.37700703067398E-10  -3.22240511272383E-18
      5.91376779731313E-09
      0.00000000000000E+00  -1.59938425373187E-12   0.00000000000000E+00   4.70723260023338E-13  -4.38071821493058E-23
      1.59891439323160E-09   1.59938511649158E-09  -1.09323756541039E-18  -1.12428707620376E-01  -1.12428707618634E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.74244477490188E-09   0.00000000000000E+00  -1.74244477490188E-09
      4.29523746193751E-18  -3.64732336150983E-01  -3.64777435911246E-01   0.00000000000000E+00   3.24180274022255E-11
     -1.31341919081520E-22   1.10641631008231E-10   1.43059658410325E-10  -3.20199989652712E-18
      5.96376779731313E-09
      0.00000000000000E+00  -2.28693395646742E-12   0.00000000000000E+00   7.93132116183496E-13  -3.79867645381714E-23
      2.28613644389936E-09   2.28692957601551E-09  -1.02230965079565E-18  -1.47939367083897E-01  -1.47939367081932E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.96572226840330E-09   0.00000000000000E+00  -1.96572226840330E-09
      4.19695134851734E-18  -3.74688225048183E-01  -3.74587073015323E-01   0.00000000000000E+00   3.49192315072760E-11
     -1.27324388502828E-22  -3.56126539119373E-10  -3.21207307612224E-10  -3.17464169772169E-18
      6.01376779731313E-09
      0.00000000000000E+00  -3.93738388408667E-12   0.00000000000000E+00   1.72210643352263E-12  -1.61231319024925E-23
      3.93564329735978E-09   3.93736540379329E-09  -9.48769745255105E-19  -1.82974268310937E-01  -1.82974268308635E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.30187709685076E-09   0.00000000000000E+00  -2.30187709685076E-09
      4.08185749367480E-18  -3.75983243021077E-01  -3.75468057660306E-01   0.00000000000000E+00   4.05669354619261E-11
     -1.22230698201648E-22  -1.67605524240433E-09  -1.63548830694253E-09  -3.13308774841970E-18
      6.06376779731313E-09
      0.00000000000000E+00  -6.80909328235441E-12   0.00000000000000E+00   2.89906670848501E-12   3.26407588402183E-23
      6.80623961654678E-09   6.80913868325530E-09  -8.83240675706149E-19  -2.12936565417862E-01  -2.12936565415276E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.58614171427090E-09   0.00000000000000E+00  -2.58614171427090E-09
      3.95255040796126E-18  -3.60340695079567E-01  -3.59010345474427E-01   0.00000000000000E+00   4.64375921641072E-11
     -1.15855044455830E-22  -4.26943456114838E-09  -4.22299696898439E-09  -3.06930973225511E-18
      6.11376779731313E-09
      0.00000000000000E+00  -9.96579690017710E-12   0.00000000000000E+00   3.15465705957646E-12   8.82968731281236E-23
      9.96268360458154E-09   9.96583826164120E-09  -8.34822754724992E-19  -2.34757415804507E-01  -2.34757415801728E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.77910845949861E-09   0.00000000000000E+00  -2.77910845949861E-09
      3.81359498498633E-18  -3.23279436962341E-01  -3.21015354698035E-01   0.00000000000000E+00   4.88036018770449E-11
     -1.08714443983399E-22  -7.23553340401954E-09  -7.18672980214260E-09  -2.97877223026134E-18
      6.16376779731313E-09
      0.00000000000000E+00  -1.20763889612061E-11   0.00000000000000E+00   2.11570604054719E-12   1.27203916515794E-22
      1.20742760226013E-08   1.20763917286420E-08  -8.03098634682833E-19  -2.49452508920608E-01  -2.49452508917708E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90027027794812E-09   0.00000000000000E+00  -2.90027027794812E-09
      3.66858147108892E-18  -2.69976720952640E-01  -2.67085832053431E-01   0.00000000000000E+00   4.40497098904546E-11
     -1.01370836920262E-22  -9.22017116058419E-09  -9.17612145069384E-09  -2.86548283640609E-18
      6.21376779731313E-09
      0.00000000000000E+00  -1.30593113388010E-11   0.00000000000000E+00   9.85028282378414E-13   1.44930797248304E-22
      1.30582878886445E-08   1.30592729169270E-08  -7.81477115100342E-19  -2.60081088392505E-01  -2.60081088389568E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.93709912249494E-09   0.00000000000000E+00  -2.93709912249494E-09
      3.52172651496418E-18  -2.11524989436244E-01  -2.08335980873181E-01   0.00000000000000E+00   3.39002798248682E-11
     -9.39212328706551E-23  -1.01560740742568E-08  -1.01221737944320E-08  -2.74024939986384E-18
      6.26376779731313E-09
      0.00000000000000E+00  -1.32880965791850E-11   0.00000000000000E+00   2.36204091867011E-13   1.47751469735902E-22
      1.32878580551035E-08   1.32880942591955E-08  -7.65522639000368E-19  -2.68544155614908E-01  -2.68544155611979E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.92838321089564E-09   0.00000000000000E+00  -2.92838321089564E-09
      3.37530735441939E-18  -1.53392978030369E-01  -1.50129082971980E-01   0.00000000000000E+00   2.50560182901210E-11
     -8.76882251731429E-23  -1.03847670665899E-08  -1.03597110482999E-08  -2.60978471541902E-18
      6.31376779731313E-09
      0.00000000000000E+00  -1.31055092416164E-11   0.00000000000000E+00  -1.46534943328743E-13   1.43253740038770E-22
      1.31057210835922E-08   1.31055745486490E-08  -7.52399378887628E-19  -2.75992451217024E-01  -2.75992451214131E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.89277799665323E-09   0.00000000000000E+00  -2.89277799665323E-09
      3.23066845458673E-18  -9.88774047907843E-02  -9.56597687852822E-02   0.00000000000000E+00   1.82901493730960E-11
     -7.99959320355546E-23  -1.02310867013688E-08  -1.02127965519958E-08  -2.47826907569911E-18
      6.36376779731313E-09
      0.00000000000000E+00  -1.24767401706937E-11   0.00000000000000E+00  -6.11042183609614E-13   1.39111167041423E-22
      1.24773219962643E-08   1.24767109540808E-08  -7.37653932482413E-19  -2.84090121771620E-01  -2.84090121768816E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.80314341636918E-09   0.00000000000000E+00  -2.80314341636918E-09
      3.09051128376827E-18  -5.44020007400421E-02  -5.13542222613982E-02   0.00000000000000E+00   1.24887436020656E-11
     -4.10775871357186E-23  -9.68605628131363E-09  -9.67356753771160E-09  -2.35285735128586E-18
      6.41376779731313E-09
      0.00000000000000E+00  -1.11705243181282E-11   0.00000000000000E+00  -1.27282690570616E-12   1.49123297609808E-22
      1.11718022877034E-08   1.11705294607978E-08  -7.13279071525887E-19  -2.95694969428559E-01  -2.95694969425957E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.60138698395453E-09   0.00000000000000E+00  -2.60138698395453E-09
      2.96044193457055E-18  -2.86381887706604E-02  -2.59383597813377E-02   0.00000000000000E+00   7.71315271921316E-12
      6.12004687828152E-23  -8.57685562956260E-09  -8.56914247684333E-09  -2.24716286304466E-18
      6.46376779731313E-09
      0.00000000000000E+00  -9.98967653185106E-12   0.00000000000000E+00  -1.14405036567848E-12   1.71015593880032E-22
      9.99077123964171E-09   9.98962718927620E-09  -6.81470576278455E-19  -3.09910340847648E-01  -3.09910340845249E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39939037751429E-09   0.00000000000000E+00  -2.39939037751429E-09
      2.84047241569483E-18  -1.73461191214984E-02  -1.49547016455978E-02   0.00000000000000E+00   4.61283771208386E-12
      1.60965450572410E-22  -7.59484964947411E-09  -7.59023681176186E-09  -2.15900183941637E-18
      6.51376779731313E-09
      0.00000000000000E+00  -9.28871749748322E-12   0.00000000000000E+00  -6.73518662541916E-13   1.89697884776461E-22
      9.28938384856100E-09   9.28871032989865E-09  -6.48690409401874E-19  -3.24404585133757E-01  -3.24404585131481E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.27646195457246E-09   0.00000000000000E+00  -2.27646195457246E-09
      2.72664931796621E-18  -1.22830091537072E-02  -1.00736908666224E-02   0.00000000000000E+00   2.96565040149710E-12
      2.31819425317728E-22  -7.01521402572793E-09  -7.01224837532620E-09  -2.07795890856433E-18
      6.56376779731313E-09
      0.00000000000000E+00  -8.94025856451786E-12   0.00000000000000E+00  -3.26296731260575E-13   1.98934083491629E-22
      8.94057125015496E-09   8.94024495342390E-09  -6.16433068992237E-19  -3.38746010406336E-01  -3.38746010404076E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26022392630494E-09   0.00000000000000E+00  -2.26022392630494E-09
      2.61363812165096E-18  -9.59262193509221E-03  -7.48797459572629E-03   0.00000000000000E+00   2.21055394649234E-12
      2.73669889855097E-22  -6.68223158106574E-09  -6.68002102711897E-09  -1.99720505265872E-18
      6.61376779731313E-09
      0.00000000000000E+00  -8.94246283821084E-12   0.00000000000000E+00   1.87106432897452E-14   1.99882961002750E-22
      8.94246245414933E-09   8.94248116479282E-09  -5.82120313310387E-19  -3.54031077166335E-01  -3.54031077163901E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43459535902533E-09   0.00000000000000E+00  -2.43459535902533E-09
      2.49190835369970E-18  -7.92830812198466E-03  -5.87789230092832E-03   0.00000000000000E+00   1.92541528593757E-12
      2.93787526890802E-22  -6.50981122105372E-09  -6.50788580576749E-09  -1.90978804038931E-18
      6.66376779731313E-09
      0.00000000000000E+00  -8.94889196981537E-12   0.00000000000000E+00   2.21662425242305E-14   1.88090551094234E-22
      8.94888919086164E-09   8.94891135710435E-09  -5.47519723602843E-19  -3.69461603122401E-01  -3.69461603119876E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.52507027948682E-09   0.00000000000000E+00  -2.52507027948682E-09
      2.36565483972535E-18  -6.79088473538158E-03  -4.76694654597821E-03   0.00000000000000E+00   1.69196070947921E-12
      2.87634485362074E-22  -6.42553303832730E-09  -6.42384107761753E-09  -1.81813511612251E-18
      6.71376779731313E-09
      0.00000000000000E+00  -8.75813045063534E-12   0.00000000000000E+00  -1.74497168989824E-13   1.62505286805935E-22
      8.75830413912840E-09   8.75812964195957E-09  -5.16082860625739E-19  -3.83515574908464E-01  -3.83515574906084E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.38014681707127E-09   0.00000000000000E+00  -2.38014681707127E-09
      2.24664749887179E-18  -5.98778642561164E-03  -3.97829479670451E-03   0.00000000000000E+00   1.39649678946109E-12
      2.54202577012079E-22  -6.37937932167799E-09  -6.37798282488828E-09  -1.73056463824605E-18
      6.73876779731313E-09
      0.00000000000000E+00  -8.58941166838511E-12   0.00000000000000E+00  -3.20675486826984E-13   1.45617381238944E-22
      8.58975189587453E-09   8.58943122038785E-09  -5.01690999710299E-19  -3.89952940036380E-01  -3.89952940034148E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.23114720617136E-09   0.00000000000000E+00  -2.23114720617136E-09
      2.19086881871751E-18  -5.66590960362499E-03  -3.66262355282336E-03   0.00000000000000E+00   1.21217590004438E-12
      2.29285164849167E-22  -6.35949619011681E-09  -6.35828401421653E-09  -1.68917781900721E-18
      6.77251779731313E-09
      0.00000000000000E+00  -8.23461544855243E-12   0.00000000000000E+00  -5.08879452237134E-13   1.21035387309393E-22
      8.23512326073571E-09   8.23461438128359E-09  -4.86062948626560E-19  -3.96997705885363E-01  -3.96997705883505E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.85763273002941E-09   0.00000000000000E+00  -1.85763273002941E-09
      2.12817371407901E-18  -5.33862090215512E-03  -3.32944280252752E-03   0.00000000000000E+00   8.89211412311783E-13
      1.91393458259783E-22  -6.37787086266664E-09  -6.37698165125414E-09  -1.64211076545245E-18
      6.81808029731313E-09
      0.00000000000000E+00  -7.28420610792895E-12   0.00000000000000E+00  -1.02478835620139E-12   8.73182204996674E-23
      7.28526557152912E-09   7.28424078317300E-09  -4.79109166788259E-19  -4.00552444782405E-01  -4.00552444781569E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.36007109467347E-10   0.00000000000000E+00  -8.36007109467347E-10
      2.09008314015391E-18  -5.06336379771391E-03  -3.03173544746434E-03   0.00000000000000E+00   2.29979084229770E-13
      1.37451263796123E-22  -6.44846365279003E-09  -6.44823367370566E-09  -1.61097397336565E-18
      6.86808029731313E-09
      0.00000000000000E+00  -5.13347789674029E-12   0.00000000000000E+00  -2.13020810980957E-12   5.01932198182104E-23
      5.13560543179794E-09   5.13347522368818E-09  -5.07125554151995E-19  -3.89818804970174E-01  -3.89818804971545E-01
      0.00000000000000E+00   0.00000000000000E+00   1.37121161873091E-09   0.00000000000000E+00   1.37121161873091E-09
      2.15864372109045E-18  -4.98455558246079E-03  -2.93514028067164E-03   0.00000000000000E+00  -1.12069390110754E-12
      7.59102989282071E-23  -6.50356614851805E-09  -6.50468684241908E-09  -1.65151816693846E-18
      6.91808029731313E-09
      0.00000000000000E+00  -2.30658873022983E-12   0.00000000000000E+00  -2.82013157327277E-12   9.87213923897383E-24
      2.30943530696526E-09   2.30661517539200E-09  -5.87078468713842E-19  -3.57974405780392E-01  -3.57974405784552E-01
      0.00000000000000E+00   0.00000000000000E+00   4.16035517187015E-09   0.00000000000000E+00   4.16035517187015E-09
      2.36666147968396E-18  -5.58937637276182E-03  -3.55184564030693E-03   0.00000000000000E+00  -3.51183557573229E-12
      4.61080124987425E-24  -6.46345851168645E-09  -6.46697034726218E-09  -1.77958301097012E-18
      6.96808029731313E-09
      0.00000000000000E+00  -2.17488337707423E-13   0.00000000000000E+00  -2.12941908421044E-12  -2.63215842556397E-23
      2.19605436536874E-10   2.17476017452638E-10  -7.11638429044327E-19  -3.06572954590194E-01  -3.06572954596208E-01
      0.00000000000000E+00   0.00000000000000E+00   6.01489050780690E-09   0.00000000000000E+00   6.01489050780690E-09
      2.66740600507430E-18  -9.34168658371414E-03  -7.37807502175645E-03   0.00000000000000E+00  -7.48591200760468E-12
     -5.98601070304259E-23  -6.22488061325189E-09  -6.23236652525955E-09  -1.95576757602998E-18
      7.01808029731313E-09
      0.00000000000000E+00   1.13749707031522E-12   0.00000000000000E+00  -1.44832541452563E-12  -4.00895385211838E-23
     -1.13602565943552E-09  -1.13747398485008E-09  -8.47073627652570E-19  -2.46101589565570E-01  -2.46101589572092E-01
      0.00000000000000E+00   0.00000000000000E+00   6.52242875847393E-09   0.00000000000000E+00   6.52242875847393E-09
      2.99352744299800E-18  -2.49575855602031E-02  -2.32609669919452E-02   0.00000000000000E+00  -1.42209027024636E-11
     -8.00187659898565E-23  -5.37073387092131E-09  -5.38495477362385E-09  -2.14645381534543E-18
      7.06808029731313E-09
      0.00000000000000E+00   2.04731103709298E-12   0.00000000000000E+00  -1.04400236308622E-12  -4.31843437173577E-23
     -2.04623162987868E-09  -2.04727563224181E-09  -9.70620967815048E-19  -1.85821797278013E-01  -1.85821797284298E-01
      0.00000000000000E+00   0.00000000000000E+00   6.28490605661930E-09   0.00000000000000E+00   6.28490605661930E-09
      3.30777274582897E-18  -5.45625682473203E-02  -5.32274315250921E-02   0.00000000000000E+00  -2.53705497212499E-11
     -8.82684143761614E-23  -4.21225987465619E-09  -4.23763042437753E-09  -2.33715177801392E-18
      7.11808029731313E-09
      0.00000000000000E+00   2.15302432961884E-12   0.00000000000000E+00  -2.86351999470380E-13  -4.47933922128358E-23
     -2.15274668892083E-09  -2.15303304092034E-09  -1.08031025066354E-18  -1.28285151077825E-01  -1.28285151083477E-01
      0.00000000000000E+00   0.00000000000000E+00   5.65121077466116E-09   0.00000000000000E+00   5.65121077466116E-09
      3.59033328456203E-18  -8.91146424557357E-02  -8.80124802090645E-02   0.00000000000000E+00  -3.99074064639524E-11
     -9.79803377169611E-23  -3.45827032727671E-09  -3.49817773374076E-09  -2.51002303389848E-18
      7.14308029731313E-09
      0.00000000000000E+00   2.01112421063321E-12   0.00000000000000E+00   7.19931144928775E-14  -4.55899071199617E-23
     -2.01122515859027E-09  -2.01115316547582E-09  -1.13012428904315E-18  -1.00826996474789E-01  -1.00826996479951E-01
      0.00000000000000E+00   0.00000000000000E+00   5.16197453453746E-09   0.00000000000000E+00   5.16197453453746E-09
      3.71938264792546E-18  -1.07062437852221E-01  -1.06069711047614E-01   0.00000000000000E+00  -5.20417226486719E-11
     -1.02915447638270E-22  -3.09877964641285E-09  -3.15082136906163E-09  -2.58925835888231E-18
      7.17683029731313E-09
      0.00000000000000E+00   1.74798903853365E-12   0.00000000000000E+00   1.78862904390821E-13  -4.65449349732822E-23
     -1.74811440350046E-09  -1.74793554059611E-09  -1.18739585086533E-18  -6.81523167499867E-02  -6.81523167545228E-02
      0.00000000000000E+00   0.00000000000000E+00   4.53611994627548E-09   0.00000000000000E+00   4.53611994627548E-09
      3.87247669611226E-18  -1.31409166972334E-01  -1.30530695695073E-01   0.00000000000000E+00  -5.89226780579323E-11
     -1.09427862945306E-22  -2.72926172762134E-09  -2.78818440567938E-09  -2.68508084524694E-18
      7.22239279731313E-09
      0.00000000000000E+00   1.19829828634660E-12   0.00000000000000E+00   4.36884180743450E-13  -4.73919400415491E-23
     -1.19875808031505E-09  -1.19832119613436E-09  -1.23919914122666E-18  -3.75155997116278E-02  -3.75155997150533E-02
      0.00000000000000E+00   0.00000000000000E+00   3.42548093550523E-09   0.00000000000000E+00   3.42548093550523E-09
      4.02855017123622E-18  -1.64362269957019E-01  -1.63660560640715E-01   0.00000000000000E+00  -6.05192014119551E-11
     -1.17318023479538E-22  -2.16664053795880E-09  -2.22715973937087E-09  -2.78935103000956E-18
      7.27239279731313E-09
      0.00000000000000E+00   5.99837978702357E-13   0.00000000000000E+00   5.12983329580300E-13  -4.77864211501328E-23
     -6.00370449737263E-10  -5.99857466407730E-10  -1.26609952145869E-18  -2.11670761421272E-02  -2.11670761443124E-02
      0.00000000000000E+00   0.00000000000000E+00   2.18518022723181E-09   0.00000000000000E+00   2.18518022723181E-09
      4.13780918259781E-18  -1.98135187439247E-01  -1.97635700902942E-01   0.00000000000000E+00  -5.28613431820013E-11
     -1.24050304382597E-22  -1.53246141764198E-09  -1.58532276082410E-09  -2.87170966113912E-18
      7.32239279731313E-09
      0.00000000000000E+00   2.93811314326878E-13   0.00000000000000E+00   2.73030955269379E-13  -4.79252229950756E-23
     -2.94119723161302E-10  -2.93846692206080E-10  -1.27775668129351E-18  -1.40612645978139E-02  -1.40612645992004E-02
      0.00000000000000E+00   0.00000000000000E+00   1.38651299604048E-09   0.00000000000000E+00   1.38651299604048E-09
      4.20713483239983E-18  -2.24997395746318E-01  -2.24653130627720E-01   0.00000000000000E+00  -4.07749370026051E-11
     -1.28811641263554E-22  -1.05189136683166E-09  -1.09266630383439E-09  -2.92937815110631E-18
      7.37239279731313E-09
      0.00000000000000E+00   1.79556461240715E-13   0.00000000000000E+00   1.02614204702421E-13  -4.79758045687999E-23
     -1.79613307852390E-10  -1.79510693647735E-10  -1.28375596132673E-18  -1.05601472225265E-02  -1.05601472234531E-02
      0.00000000000000E+00   0.00000000000000E+00   9.26517228662483E-10   0.00000000000000E+00   9.26517228662483E-10
      4.25346069383296E-18  -2.43615209904961E-01  -2.43379853060715E-01   0.00000000000000E+00  -2.81590226941500E-11
     -1.31920691675056E-22  -7.18847512320474E-10  -7.47006535014755E-10  -2.96970473250623E-18
      7.42239279731313E-09
      0.00000000000000E+00   1.34277005797404E-13   0.00000000000000E+00   4.14105391650850E-14  -4.79929113249099E-23
     -1.34359644019569E-10  -1.34318233480451E-10  -1.28754716970788E-18  -8.53077026780839E-03  -8.53077026847061E-03
      0.00000000000000E+00   0.00000000000000E+00   6.62213856555407E-10   0.00000000000000E+00   6.62213856555407E-10
      4.28657138666072E-18  -2.56002314833969E-01  -2.55835994627257E-01   0.00000000000000E+00  -1.83733330150512E-11
     -1.33881902707443E-22  -5.09522290059769E-10  -5.27895623074954E-10  -2.99902421695285E-18
      7.47239279731313E-09
      0.00000000000000E+00   1.11775045181560E-13   0.00000000000000E+00   2.22976649018164E-14  -4.79938514473088E-23
     -1.11751975910794E-10  -1.11729678245940E-10  -1.29025682193215E-18  -7.20516145217366E-03  -7.20516145270682E-03
      0.00000000000000E+00   0.00000000000000E+00   5.33160769343972E-10   0.00000000000000E+00   5.33160769343972E-10
      4.31322942512793E-18  -2.65337999945246E-01  -2.65205224323049E-01   0.00000000000000E+00  -1.33333343994213E-11
     -1.35269485653033E-22  -4.08097756698459E-10  -4.21431091098016E-10  -3.02297260319577E-18
      7.52239279731313E-09
      0.00000000000000E+00   9.83657135492612E-14   0.00000000000000E+00   1.48490264519359E-14  -4.79859620688939E-23
     -9.83887804933406E-11  -9.83739314669366E-11  -1.29234488686094E-18  -6.26594580639823E-03  -6.26594580686352E-03
      0.00000000000000E+00   0.00000000000000E+00   4.65292251344721E-10   0.00000000000000E+00   4.65292251344721E-10
      4.33649403769516E-18  -2.73141441791066E-01  -2.73025841967318E-01   0.00000000000000E+00  -1.07178574103134E-11
     -1.36361449804315E-22  -3.56200462467359E-10  -3.66918319877809E-10  -3.04414915083422E-18
      7.54739279731313E-09
      0.00000000000000E+00   9.21202714191493E-14   0.00000000000000E+00   1.47752089740933E-14  -4.79798777890513E-23
     -9.21374649892261E-11  -9.21226897803000E-11  -1.29324395841735E-18  -5.88785074128173E-03  -5.88785074171267E-03
      0.00000000000000E+00   0.00000000000000E+00   4.30946074014021E-10   0.00000000000000E+00   4.30946074014021E-10
      4.34726768954551E-18  -2.76632884215983E-01  -2.76526136492994E-01   0.00000000000000E+00  -9.29474737100997E-12
     -1.36829591774281E-22  -3.29528636862524E-10  -3.38823384233671E-10  -3.05402373112816E-18
      7.58114279731313E-09
      0.00000000000000E+00   8.53237608657924E-14   0.00000000000000E+00   1.31039104470103E-14  -4.79688048994160E-23
     -8.53721042705289E-11  -8.53590003601299E-11  -1.29425058990794E-18  -5.48734452045199E-03  -5.48734452087430E-03
      0.00000000000000E+00   0.00000000000000E+00   4.22312100444623E-10   0.00000000000000E+00   4.22312100444623E-10
      4.36152072293552E-18  -2.81443112090587E-01  -2.81336953643497E-01   0.00000000000000E+00  -9.44734889065450E-12
     -1.37462482265871E-22  -3.27505751193691E-10  -3.36953100084483E-10  -3.06727013302758E-18
      7.62670529731313E-09
      0.00000000000000E+00   7.65985108310773E-14   0.00000000000000E+00   1.37304141664659E-14  -4.79486929636477E-23
     -7.65868446762749E-11  -7.65731142621564E-11  -1.29525133265367E-18  -5.10489036007302E-03  -5.10489036052059E-03
      0.00000000000000E+00   0.00000000000000E+00   4.47574001956818E-10   0.00000000000000E+00   4.47574001956818E-10
      4.38191331339967E-18  -2.89295304357041E-01  -2.89178418154709E-01   0.00000000000000E+00  -1.18978140600059E-11
     -1.38517614028653E-22  -3.59103073634518E-10  -3.71000887694663E-10  -3.08666198074600E-18
      7.67670529731313E-09
      0.00000000000000E+00   6.51179186801365E-14   0.00000000000000E+00   1.68876621020250E-14  -4.79187304119954E-23
     -6.51719570832904E-11  -6.51550694212363E-11  -1.29583860937977E-18  -4.87031164390362E-03  -4.87031164443131E-03
      0.00000000000000E+00   0.00000000000000E+00   5.27689367905424E-10   0.00000000000000E+00   5.27689367905424E-10
      4.40829778179495E-18  -3.01579972614882E-01  -3.01434246121303E-01   0.00000000000000E+00  -1.83109217601912E-11
     -1.40256512422312E-22  -4.44223376723883E-10  -4.62534298484214E-10  -3.11245917241517E-18
      7.72670529731313E-09
      0.00000000000000E+00   5.36373265291956E-14   0.00000000000000E+00   1.84295413247897E-14  -4.78809444589037E-23
     -5.36320437691161E-11  -5.36136142278392E-11  -1.29591538047339E-18  -4.86551023305774E-03  -4.86551023362193E-03
      0.00000000000000E+00   0.00000000000000E+00   5.64192752388519E-10   0.00000000000000E+00   5.64192752388519E-10
      4.43650741941437E-18  -3.15956769455969E-01  -3.15795905091564E-01   0.00000000000000E+00  -2.23236722097485E-11
     -1.42323463071826E-22  -4.88255465950782E-10  -5.10579138160673E-10  -3.14059203894098E-18
      7.77670529731313E-09
      0.00000000000000E+00   2.08487553461086E-14   0.00000000000000E+00   4.43103651889348E-14  -4.78156769813533E-23
     -2.08945857375003E-11  -2.08502753723592E-11  -1.29443046524592E-18  -5.77770079417753E-03  -5.77770079468422E-03
      0.00000000000000E+00   0.00000000000000E+00   5.06691181412563E-10   0.00000000000000E+00   5.06691181412563E-10
      4.46184197848500E-18  -3.30337391875961E-01  -3.30184322222643E-01   0.00000000000000E+00  -2.14765206232995E-11
     -1.44263939213269E-22  -4.64364385416765E-10  -4.85840906040208E-10  -3.16741151323908E-18
      7.82670529731313E-09
      0.00000000000000E+00  -1.27572339981255E-13   0.00000000000000E+00   1.81786929951399E-13  -4.76178382372655E-23
      1.27382483064285E-10   1.27564269994189E-10  -1.28565960066859E-18  -1.10108019450323E-02  -1.10108019452746E-02
      0.00000000000000E+00   0.00000000000000E+00   2.42259730160491E-10   0.00000000000000E+00   2.42259730160491E-10
      4.47395496499302E-18  -3.44445367003073E-01  -3.44328852465637E-01   0.00000000000000E+00  -1.34985886665852E-11
     -1.45468627453623E-22  -3.56325411487930E-10  -3.69824000154661E-10  -3.18829536432444E-18
      7.87670529731313E-09
      0.00000000000000E+00  -6.19400907727560E-13   0.00000000000000E+00   5.92840329317015E-13  -4.69858961122508E-23
      6.18834470691899E-10   6.19427311021169E-10  -1.25279142639793E-18  -3.02211089957989E-02  -3.02211089952299E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.69010780066501E-10   0.00000000000000E+00  -5.69010780066501E-10
      4.44550442598970E-18  -3.59473866128369E-01  -3.59457992653879E-01   0.00000000000000E+00   1.07350547258381E-11
     -1.44562026946337E-22  -6.11515856803593E-11  -5.04165309546658E-11  -3.19271299959177E-18
      7.92670529731313E-09
      0.00000000000000E+00  -1.10948442546692E-12   0.00000000000000E+00   6.36311345372881E-13  -4.59951166342846E-23
      1.10888807860700E-09   1.10952438995233E-09  -1.19722002823180E-18  -6.15839153308286E-02  -6.15839153295009E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.32767811352326E-09   0.00000000000000E+00  -1.32767811352326E-09
      4.37912052031354E-18  -3.74839911471981E-01  -3.74908661665178E-01   0.00000000000000E+00   3.11684547136623E-11
     -1.41804272033714E-22   1.86985268857388E-10   2.18153723570909E-10  -3.18190049208173E-18
      7.97670529731313E-09
      0.00000000000000E+00  -1.41293943720059E-12   0.00000000000000E+00   4.46522373099845E-13  -4.49156574193676E-23
      1.41247351472190E-09   1.41292003709495E-09  -1.13213647214520E-18  -9.66670084646150E-02  -9.66670084629577E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.65735188561643E-09   0.00000000000000E+00  -1.65735188561643E-09
      4.29625292603271E-18  -3.89010214828124E-01  -3.89087250916497E-01   0.00000000000000E+00   3.69808026147212E-11
     -1.38345434722931E-22   2.07451045906905E-10   2.44431848521488E-10  -3.16411645388751E-18
      8.02670529731313E-09
      0.00000000000000E+00  -1.83707843362495E-12   0.00000000000000E+00   5.45176666404893E-13  -4.31627102163552E-23
      1.83651980364437E-09   1.83706498031073E-09  -1.06253449650793E-18  -1.32379402609677E-01  -1.32379402607828E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.84895454853321E-09   0.00000000000000E+00  -1.84895454853321E-09
      4.20380519860605E-18  -4.00705561754967E-01  -4.00709346592094E-01   0.00000000000000E+00   3.85764273589124E-11
     -1.34464287482034E-22  -2.66868591362998E-11   1.18895682224781E-11  -3.14127070209812E-18
      8.07670529731313E-09
      0.00000000000000E+00  -2.88052649303966E-12   0.00000000000000E+00   1.13253331987214E-12  -3.66713764236034E-23
      2.87940817030253E-09   2.88054070362236E-09  -9.88574885663941E-19  -1.68430657141351E-01  -1.68430657139226E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.12462668726902E-09   0.00000000000000E+00  -2.12462668726902E-09
      4.09757386424260E-18  -4.07050329336206E-01  -4.06812242848964E-01   0.00000000000000E+00   4.26899850103872E-11
     -1.29767540076254E-22  -7.98604001363608E-10  -7.55914016353351E-10  -3.10899897857866E-18
      8.12670529731313E-09
      0.00000000000000E+00  -5.11363943350347E-12   0.00000000000000E+00   2.28479632857813E-12  -1.49425725402682E-23
      5.11139107319501E-09   5.11367586952358E-09  -9.16139517708818E-19  -2.02018048468879E-01  -2.02018048466446E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43276502002599E-09   0.00000000000000E+00  -2.43276502002599E-09
      3.97593561324130E-18  -4.01293448864016E-01  -4.00448936293039E-01   0.00000000000000E+00   4.90916142252606E-11
     -1.23751896848122E-22  -2.73000246372269E-09  -2.68091084949755E-09  -3.05979609553249E-18
      8.17670529731313E-09
      0.00000000000000E+00  -8.35594234640358E-12   0.00000000000000E+00   3.25192616539013E-12   2.48534995378420E-23
      8.35264402242744E-09   8.35589594859286E-09  -8.56816733727703E-19  -2.28564220000318E-01  -2.28564219997673E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.64539174215881E-09   0.00000000000000E+00  -2.64539174215881E-09
      3.84366602613336E-18  -3.75835920122412E-01  -3.74036960502784E-01   0.00000000000000E+00   5.42007698631975E-11
     -1.16361542089613E-22  -5.76470497629714E-09  -5.71050420643406E-09  -2.98684929240566E-18
      8.22670529731313E-09
      0.00000000000000E+00  -1.12357340815456E-11   0.00000000000000E+00   2.87301296009419E-12   6.22086858997802E-23
      1.12328232577455E-08   1.12356962707057E-08  -8.15779424292520E-19  -2.46896389917570E-01  -2.46896389914773E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.79789510478768E-09   0.00000000000000E+00  -2.79789510478768E-09
      3.70377127089398E-18  -3.29396849383832E-01  -3.26738626960082E-01   0.00000000000000E+00   5.41205756640805E-11
     -1.08479439369696E-22  -8.49192174158195E-09  -8.43780116591798E-09  -2.88799184660146E-18
      8.27670529731313E-09
      0.00000000000000E+00  -1.27385895164723E-11   0.00000000000000E+00   1.50977420424595E-12   8.28880233349639E-23
      1.27370965228565E-08   1.27386062970608E-08  -7.89728746331387E-19  -2.59065056519110E-01  -2.59065056516220E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.89012625119184E-09   0.00000000000000E+00  -2.89012625119184E-09
      3.55926495833439E-18  -2.69916534493849E-01  -2.66813814920249E-01   0.00000000000000E+00   4.59730062882720E-11
     -1.00618471514175E-22  -9.89445305215716E-09  -9.84848004586898E-09  -2.76953621200300E-18
      8.32670529731313E-09
      0.00000000000000E+00  -1.32817592923177E-11   0.00000000000000E+00   5.48101554595172E-13   8.96498262627842E-23
      1.32811961552409E-08   1.32817442567956E-08  -7.71330609598193E-19  -2.68254905079275E-01  -2.68254905076373E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90146222037982E-09   0.00000000000000E+00  -2.90146222037982E-09
      3.41419184731539E-18  -2.08858174134430E-01  -2.05587842113923E-01   0.00000000000000E+00   3.36724510992381E-11
     -9.27572689646488E-23  -1.04139544875149E-08  -1.03802820364157E-08  -2.64286123771720E-18
      8.37670529731313E-09
      0.00000000000000E+00  -1.32964544502709E-11   0.00000000000000E+00   2.34350722543519E-14   8.82088216758606E-23
      1.32964673220468E-08   1.32964907571192E-08  -7.56958653695731E-19  -2.75965660031035E-01  -2.75965660028158E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87678590672950E-09   0.00000000000000E+00  -2.87678590672950E-09
      3.27035255197892E-18  -1.50082145468102E-01  -1.46799344704020E-01   0.00000000000000E+00   2.43706693439176E-11
     -8.67679549651503E-23  -1.04440755197335E-08  -1.04197048503897E-08  -2.51339389828319E-18
      8.40170529731313E-09
      0.00000000000000E+00  -1.31158876969209E-11   0.00000000000000E+00  -3.48771079795385E-13   8.56908617274620E-23
      1.31162656502040E-08   1.31159168791243E-08  -7.50888779005775E-19  -2.79415714752700E-01  -2.79415714749831E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86982248196053E-09   0.00000000000000E+00  -2.86982248196053E-09
      3.19860698992991E-18  -1.21580548907634E-01  -1.18352425990815E-01   0.00000000000000E+00   1.95905267610365E-11
     -8.40660557914318E-23  -1.02656849239247E-08  -1.02460943971638E-08  -2.44771821092413E-18
      8.41858029731313E-09
      0.00000000000000E+00  -1.29681095147539E-11   0.00000000000000E+00  -4.25157243449182E-13   8.37061557538675E-23
      1.29685721677558E-08   1.29681470105124E-08  -7.46942049475745E-19  -2.81700286855058E-01  -2.81700286852204E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.85405451009991E-09   0.00000000000000E+00  -2.85405451009991E-09
      3.15044482007197E-18  -1.03100705326892E-01  -9.99141595996143E-02   0.00000000000000E+00   1.70790685046776E-11
     -8.18230719689310E-23  -1.01311715689172E-08  -1.01140925004126E-08  -2.40350277059623E-18
      8.44136154731313E-09
      0.00000000000000E+00  -1.27557644823301E-11   0.00000000000000E+00  -4.52261059273558E-13   8.16574384012623E-23
      1.27561698719243E-08   1.27557176108651E-08  -7.41283749040013E-19  -2.84928005942196E-01  -2.84928005939379E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81667961282043E-09   0.00000000000000E+00  -2.81667961282043E-09
      3.08627733764241E-18  -8.00041135764854E-02  -7.68727079542313E-02   0.00000000000000E+00   1.46290205107771E-11
     -7.64215852772119E-23  -9.95366701855540E-09  -9.93903799804470E-09  -2.34499358860239E-18
      8.47211623481313E-09
      0.00000000000000E+00  -1.22748654383115E-11   0.00000000000000E+00  -7.60914729971947E-13   8.08929589022315E-23
      1.22756524793155E-08   1.22748915645856E-08  -7.31774475469935E-19  -2.89991265379073E-01  -2.89991265376333E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.73912786440595E-09   0.00000000000000E+00  -2.73912786440595E-09
      3.00203631615006E-18  -5.38467583977306E-02  -5.08423954735490E-02   0.00000000000000E+00   1.15772808737439E-11
     -5.67302698755600E-23  -9.54734098105341E-09  -9.53576370017972E-09  -2.27026184068012E-18
      8.51363506293813E-09
      0.00000000000000E+00  -1.12449185552663E-11   0.00000000000000E+00  -1.19694311127609E-12   8.77609610564170E-23
      1.12461145723006E-08   1.12449176291894E-08  -7.11907099425887E-19  -2.99368762746200E-01  -2.99368762743631E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.56836481495541E-09   0.00000000000000E+00  -2.56836481495541E-09
      2.89540081883563E-18  -3.12279951014801E-02  -2.84943294456721E-02   0.00000000000000E+00   7.92505338080951E-12
      7.72844286806763E-25  -8.68447786761478E-09  -8.67655281423397E-09  -2.18349371940974E-18
      8.56363506293813E-09
      0.00000000000000E+00  -1.00900628296189E-11   0.00000000000000E+00  -1.12028509617166E-12   1.05614188305222E-22
      1.00911781988901E-08   1.00900579137940E-08  -6.80078110573438E-19  -3.13405292831822E-01  -3.13405292829462E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.36044591350310E-09   0.00000000000000E+00  -2.36044591350310E-09
      2.77737852316047E-18  -1.84789144434951E-02  -1.60435844883641E-02   0.00000000000000E+00   4.87414670224579E-12
      7.88043862801123E-23  -7.73448614699327E-09  -7.72961200029095E-09  -2.09730041258703E-18
      8.61363506293813E-09
      0.00000000000000E+00  -9.33261928186842E-12   0.00000000000000E+00  -7.28759008555588E-13   1.23128584792733E-22
      9.33335523816134E-09   9.33262647915291E-09  -6.46454366949892E-19  -3.27947226923764E-01  -3.27947226921549E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.21489661800255E-09   0.00000000000000E+00  -2.21489661800255E-09
      2.66663369226034E-18  -1.27321495544948E-02  -1.04895977765463E-02   0.00000000000000E+00   3.15337801156147E-12
      1.38739237188253E-22  -7.12088323916206E-09  -7.11772986115036E-09  -2.02017932531045E-18
      8.66363506293813E-09
      0.00000000000000E+00  -8.88910104589327E-12   0.00000000000000E+00  -4.20756954221367E-13   1.34522745028773E-22
      8.88954081948077E-09   8.88912006252668E-09  -6.13795870024342E-19  -3.42077337440959E-01  -3.42077337438820E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.13968106104224E-09   0.00000000000000E+00  -2.13968106104224E-09
      2.55964963920823E-18  -9.75019134406278E-03  -7.62367242003995E-03   0.00000000000000E+00   2.30156654102557E-12
      1.78225947196161E-22  -6.75174056802562E-09  -6.74943900148442E-09  -1.94585376918389E-18
      8.71363506293814E-09
      0.00000000000000E+00  -8.75702831378885E-12   0.00000000000000E+00  -1.14365653824266E-13   1.39479634038856E-22
      8.75713689085808E-09   8.75702252520439E-09  -5.80447394273665E-19  -3.56543196416982E-01  -3.56543196414764E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.21798256454886E-09   0.00000000000000E+00  -2.21798256454886E-09
      2.44875051098079E-18  -7.96492615826437E-03  -5.90469458619865E-03   0.00000000000000E+00   1.92691320785349E-12
      2.00609446212668E-22  -6.54096687386358E-09  -6.53903996065553E-09  -1.86830311670712E-18
      8.76363506293814E-09
      0.00000000000000E+00  -8.85401635627999E-12   0.00000000000000E+00   1.11644897011138E-13   1.36809773071009E-22
      8.85392827125180E-09   8.85403991614895E-09  -5.44761426071550E-19  -3.71990903033708E-01  -3.71990903031297E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41143201268086E-09   0.00000000000000E+00  -2.41143201268086E-09
      2.32817891034675E-18  -6.78039588007182E-03  -4.75054480926427E-03   0.00000000000000E+00   1.75565233316233E-12
      2.06419544747665E-22  -6.44436355580147E-09  -6.44260790346810E-09  -1.78341748427520E-18
      8.81363506293814E-09
      0.00000000000000E+00  -8.78550018232318E-12   0.00000000000000E+00  -5.30174194404035E-14   1.22404749447202E-22
      8.78550807358737E-09   8.78545505616805E-09  -5.10505196461998E-19  -3.86810538305974E-01  -3.86810538303582E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39260138333040E-09   0.00000000000000E+00  -2.39260138333040E-09
      2.20854884118023E-18  -5.93504998727423E-03  -3.92087290438682E-03   0.00000000000000E+00   1.51234028460453E-12
      1.89591150962631E-22  -6.39436601312244E-09  -6.39285367283765E-09  -1.69804364471823E-18
      8.83863506293814E-09
      0.00000000000000E+00  -8.68704262403671E-12   0.00000000000000E+00  -1.80829100220361E-13   1.11341072281256E-22
      8.68722918595898E-09   8.68704835685887E-09  -4.94265587964297E-19  -3.93827681552148E-01  -3.93827681549827E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.32090848998026E-09   0.00000000000000E+00  -2.32090848998026E-09
      2.15052612893072E-18  -5.59516184491619E-03  -3.58940048967933E-03   0.00000000000000E+00   1.35887809208409E-12
      1.73720676044659E-22  -6.36749874497093E-09  -6.36613986687868E-09  -1.65626054096642E-18
      8.87238506293814E-09
      0.00000000000000E+00  -8.46358437841080E-12   0.00000000000000E+00  -3.15077993879957E-13   9.41345860922325E-23
      8.46391326219235E-09   8.46359818419856E-09  -4.74802580500961E-19  -4.02237662073962E-01  -4.02237662071864E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.09799901144235E-09   0.00000000000000E+00  -2.09799901144235E-09
      2.07971866229454E-18  -5.23585820261100E-03  -3.23026610711284E-03   0.00000000000000E+00   1.11685893563731E-12
      1.47564582905080E-22  -6.36671603169193E-09  -6.36559917275614E-09  -1.60491608179358E-18
      8.91794756293814E-09
      0.00000000000000E+00  -7.91132197358194E-12   0.00000000000000E+00  -5.89915112586536E-13   6.99079180799785E-23
      7.91193219991954E-09   7.91134228480702E-09  -4.56770466744563E-19  -4.10099190111260E-01  -4.10099190109753E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.50721816839851E-09   0.00000000000000E+00  -1.50721816839851E-09
      2.01104603449688E-18  -4.89688367976553E-03  -2.87915239448246E-03   0.00000000000000E+00   6.97947342008353E-13
      1.09132317941246E-22  -6.40482206375069E-09  -6.40412411640858E-09  -1.55427556775232E-18
      8.96794756293814E-09
      0.00000000000000E+00  -6.52327246016459E-12   0.00000000000000E+00  -1.36886160848538E-12   4.43573220040776E-23
      6.52465938643117E-09   6.52329052482272E-09  -4.59799210972373E-19  -4.09311900609660E-01  -4.09311900609626E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.44895879870087E-11   0.00000000000000E+00  -3.44895879870087E-11
      2.00932155509753E-18  -4.68456463780165E-03  -2.64015354158889E-03   0.00000000000000E+00  -1.72624521865099E-13
      6.73470586013598E-23  -6.48862831231392E-09  -6.48880093683572E-09  -1.54952234412516E-18
      9.01794756293814E-09
      0.00000000000000E+00  -3.96337594471640E-12   0.00000000000000E+00  -2.54007361907079E-12   1.86879959291987E-23
      3.96594303739354E-09   3.96340296377449E-09  -5.06016211487234E-19  -3.91050837112445E-01  -3.91050837115001E-01
      0.00000000000000E+00   0.00000000000000E+00   2.55610373703667E-09   0.00000000000000E+00   2.55610373703667E-09
      2.13712674194937E-18  -4.68139656437424E-03  -2.62731111268675E-03   0.00000000000000E+00  -1.75522113460176E-12
      2.36262363487682E-23  -6.51775147967659E-09  -6.51950670081117E-09  -1.63111053046213E-18
      9.06794756293814E-09
      0.00000000000000E+00  -1.25808921026870E-12   0.00000000000000E+00  -2.71150692051263E-12  -1.14234279073432E-23
      1.26077969042873E-09   1.25806818350821E-09  -6.05543892048981E-19  -3.51238049001185E-01  -3.51238049006377E-01
      0.00000000000000E+00   0.00000000000000E+00   5.19197266990039E-09   0.00000000000000E+00   5.19197266990039E-09
      2.39672537544439E-18  -5.59640424405983E-03  -3.56420684887693E-03   0.00000000000000E+00  -4.46460377358292E-12
     -3.08119694560595E-23  -6.44557624963496E-09  -6.45004085340857E-09  -1.79118148339540E-18
      9.11794756293814E-09
      0.00000000000000E+00   3.64348072502259E-13   0.00000000000000E+00  -1.68422227594237E-12  -3.43285981484356E-23
     -3.62724737143150E-10  -3.64408959419127E-10  -7.41385922236393E-19  -2.94506271451699E-01  -2.94506271458190E-01
      0.00000000000000E+00   0.00000000000000E+00   6.49127275550308E-09   0.00000000000000E+00   6.49127275550308E-09
      2.72128901321954E-18  -1.09310490963494E-02  -9.00067752182162E-03   0.00000000000000E+00  -8.91121791684236E-12
     -7.05610247884553E-23  -6.11795257816705E-09  -6.12686379608397E-09  -1.97990309098315E-18
      9.16794756293814E-09
      0.00000000000000E+00   1.50937641126849E-12   0.00000000000000E+00  -1.25115099300706E-12  -4.15098313791604E-23
     -1.50811591267479E-09  -1.50936706366784E-09  -8.76995727770330E-19  -2.32676433595334E-01  -2.32676433601951E-01
      0.00000000000000E+00   0.00000000000000E+00   6.61726504720968E-09   0.00000000000000E+00   6.61726504720968E-09
      3.05215226558002E-18  -3.04742852892366E-02  -2.88649577266373E-02   0.00000000000000E+00  -1.65378738138046E-11
     -8.16838149475307E-23  -5.09136010972793E-09  -5.10789798354182E-09  -2.17515653780970E-18
      9.21794756293814E-09
      0.00000000000000E+00   2.14292140852601E-12   0.00000000000000E+00  -7.80539955156437E-13  -4.35651554498017E-23
     -2.14211589879293E-09  -2.14289643874813E-09  -9.97771406097202E-19  -1.72657638192411E-01  -1.72657638198596E-01
      0.00000000000000E+00   0.00000000000000E+00   6.18472971713208E-09   0.00000000000000E+00   6.18472971713208E-09
      3.36138875143663E-18  -6.20178245302819E-02  -6.07443762851485E-02   0.00000000000000E+00  -2.86263780940870E-11
     -9.05572585833958E-23  -4.01320690028979E-09  -4.04183327838397E-09  -2.36361734533943E-18
      9.23044756293814E-09
      0.00000000000000E+00   2.14687073222594E-12   0.00000000000000E+00  -2.01511591617638E-13  -4.39820203891313E-23
     -2.14665949236708E-09  -2.14686100395874E-09  -1.02669814731944E-18  -1.57615409737775E-01  -1.57615409743679E-01
      0.00000000000000E+00   0.00000000000000E+00   5.90457743145058E-09   0.00000000000000E+00   5.90457743145058E-09
      3.43519596932976E-18  -7.05500764374496E-02  -6.93661380671591E-02   0.00000000000000E+00  -3.81531659078361E-11
     -9.30191814642041E-23  -3.71956326158390E-09  -3.75771642749183E-09  -2.40849782201032E-18
      9.24732256293814E-09
      0.00000000000000E+00   2.12409323739847E-12   0.00000000000000E+00  -1.25364377320590E-13  -4.45360380036077E-23
     -2.12395785000707E-09  -2.12408321438444E-09  -1.06371794947502E-18  -1.37954153669009E-01  -1.37954153674654E-01
      0.00000000000000E+00   0.00000000000000E+00   5.64491024979880E-09   0.00000000000000E+00   5.64491024979880E-09
      3.53045382979512E-18  -8.25201833334135E-02  -8.14108802393130E-02   0.00000000000000E+00  -4.32140274191234E-11
     -9.63595193068126E-23  -3.47761300799520E-09  -3.52082703541442E-09  -2.46673588032010E-18
      9.27010381293814E-09
      0.00000000000000E+00   2.04180035286053E-12   0.00000000000000E+00  -2.32584670018446E-14  -4.52749598247012E-23
     -2.04174192999646E-09  -2.04176518846350E-09  -1.11018886769311E-18  -1.12613067262663E-01  -1.12613067267959E-01
      0.00000000000000E+00   0.00000000000000E+00   5.29684253765529E-09   0.00000000000000E+00   5.29684253765529E-09
      3.65112252385607E-18  -9.90226681788298E-02  -9.79970937425840E-02   0.00000000000000E+00  -4.93209206698934E-11
     -1.00847343513358E-22  -3.20575642852177E-09  -3.25507734919176E-09  -2.54093365616297E-18
      9.30085850043814E-09
      0.00000000000000E+00   1.85581476001529E-12   0.00000000000000E+00   9.08927636399996E-14  -4.61995627504697E-23
     -1.85588025429569E-09  -1.85578936153209E-09  -1.16590498631959E-18  -8.12274360963549E-02  -8.12274361011461E-02
      0.00000000000000E+00   0.00000000000000E+00   4.79124125828868E-09   0.00000000000000E+00   4.79124125828868E-09
      3.79847565149185E-18  -1.21385984646045E-01  -1.20461113977055E-01   0.00000000000000E+00  -5.64757602740966E-11
     -1.06840282223061E-22  -2.87897613648242E-09  -2.93545189675662E-09  -2.63257066517226E-18
      9.34237732856314E-09
      0.00000000000000E+00   1.43718644782338E-12   0.00000000000000E+00   3.13530368731163E-13  -4.71467222287558E-23
     -1.43750945637331E-09  -1.43719592600462E-09  -1.22303847589799E-18  -4.78486320540849E-02  -4.78486320579903E-02
      0.00000000000000E+00   0.00000000000000E+00   3.90538221422654E-09   0.00000000000000E+00   3.90538221422654E-09
      3.96062254440675E-18  -1.51610166265188E-01  -1.50832516777566E-01   0.00000000000000E+00  -6.13944641680469E-11
     -1.14485840130624E-22  -2.40679182405373E-09  -2.46818628822189E-09  -2.73758406850876E-18
      9.39237732856314E-09
      0.00000000000000E+00   7.97947076858992E-13   0.00000000000000E+00   5.23491986866821E-13  -4.77120186265078E-23
     -7.98496342246655E-10  -7.97972850259836E-10  -1.25976173472844E-18  -2.56916619314149E-02  -2.56916619340355E-02
      0.00000000000000E+00   0.00000000000000E+00   2.62062784661800E-09   0.00000000000000E+00   2.62062784661800E-09
      4.09165393673766E-18  -1.87097432576466E-01  -1.86523169939364E-01   0.00000000000000E+00  -5.71772371267405E-11
     -1.22047742061503E-22  -1.76547775923128E-09  -1.82265499635814E-09  -2.83189220200921E-18
      9.44237732856314E-09
      0.00000000000000E+00   3.79318764667086E-13   0.00000000000000E+00   3.69985396313058E-13  -4.79170236960571E-23
     -3.79737270759435E-10  -3.79367285363170E-10  -1.27560507480686E-18  -1.59836311958461E-02  -1.59836311974967E-02
      0.00000000000000E+00   0.00000000000000E+00   1.65059139735418E-09   0.00000000000000E+00   1.65059139735418E-09
      4.17418350660537E-18  -2.17354251660364E-01  -2.16953728008445E-01   0.00000000000000E+00  -4.64973497588852E-11
     -1.27607616900834E-22  -1.22472676223200E-09  -1.27122411199101E-09  -2.89857843179850E-18
      9.49237732856314E-09
      0.00000000000000E+00   2.11610274526142E-13   0.00000000000000E+00   1.50333334911342E-13  -4.79898043315617E-23
     -2.11717863635552E-10  -2.11567530300689E-10  -1.28312242441220E-18  -1.14771135393200E-02  -1.14771135404079E-02
      0.00000000000000E+00   0.00000000000000E+00   1.08785350835121E-09   0.00000000000000E+00   1.08785350835121E-09
      4.22857618202292E-18  -2.39465734469261E-01  -2.39189644975857E-01   0.00000000000000E+00  -3.37738178602834E-11
     -1.31378918582925E-22  -8.42512160190102E-10  -8.76285978050517E-10  -2.94545375761072E-18
      9.54237732856314E-09
      0.00000000000000E+00   1.48421095327363E-13   0.00000000000000E+00   5.72501369200572E-14  -4.80155311016248E-23
     -1.48442725631450E-10  -1.48385475494578E-10  -1.28753655057364E-18  -9.01816306442734E-03  -9.01816306518016E-03
      0.00000000000000E+00   0.00000000000000E+00   7.52818898379422E-10   0.00000000000000E+00   7.52818898379422E-10
      4.26621712694189E-18  -2.54114628125873E-01  -2.53924192718559E-01   0.00000000000000E+00  -2.21769230507054E-11
     -1.33754629597698E-22  -5.82256499834004E-10  -6.04433422884843E-10  -2.97868057636825E-18
      9.59237732856314E-09
      0.00000000000000E+00   1.19581847844200E-13   0.00000000000000E+00   2.75793324263654E-14  -4.80205150761913E-23
     -1.19609072264567E-10  -1.19581492932189E-10  -1.29056015218631E-18  -7.48815117204803E-03  -7.48815117262037E-03
      0.00000000000000E+00   0.00000000000000E+00   5.72345811789568E-10   0.00000000000000E+00   5.72345811789568E-10
      4.29483441753138E-18  -2.64317457970846E-01  -2.64174810064405E-01   0.00000000000000E+00  -1.49106393231280E-11
     -1.35309853424907E-22  -4.37853679534147E-10  -4.52764318857410E-10  -3.00427426534506E-18
      9.64237732856314E-09
      0.00000000000000E+00   1.03325329358468E-13   0.00000000000000E+00   1.73624364166939E-14  -4.80144604810104E-23
     -1.03322161126824E-10  -1.03304798690456E-10  -1.29281726984442E-18  -6.44221557590333E-03  -6.44221557639063E-03
      0.00000000000000E+00   0.00000000000000E+00   4.87298603276605E-10   0.00000000000000E+00   4.87298603276605E-10
      4.31919934769520E-18  -2.72579161983722E-01  -2.72458182170278E-01   0.00000000000000E+00  -1.15818871204718E-11
     -1.36490574628817E-22  -3.72411917465531E-10  -3.83993804586139E-10  -3.02638207785078E-18
      9.65487732856314E-09
      0.00000000000000E+00   9.95596951329590E-14   0.00000000000000E+00   1.64940602738510E-14  -4.80122997319086E-23
     -9.95935267552785E-11  -9.95770326950527E-11  -1.29333778790665E-18  -6.21294941246992E-03  -6.21294941291914E-03
      0.00000000000000E+00   0.00000000000000E+00   4.49217877676212E-10   0.00000000000000E+00   4.49217877676212E-10
      4.32481457116616E-18  -2.74360489864589E-01  -2.74250333934211E-01   0.00000000000000E+00  -9.67519838707862E-12
     -1.36736036530815E-22  -3.39965646593988E-10  -3.49640844981203E-10  -3.03147678325950E-18
      9.67175232856314E-09
      0.00000000000000E+00   9.43245451121300E-14   0.00000000000000E+00   1.76906337368961E-14  -4.80081142254672E-23
     -9.43857402643885E-11  -9.43680496306996E-11  -1.29395781379745E-18  -5.95069686487165E-03  -5.95069686530873E-03
      0.00000000000000E+00   0.00000000000000E+00   4.37078294851707E-10   0.00000000000000E+00   4.37078294851707E-10
      4.33219026739178E-18  -2.76744902617866E-01  -2.76636930335086E-01   0.00000000000000E+00  -9.49257611527628E-12
     -1.37057415315734E-22  -3.33217669105496E-10  -3.42710245220909E-10  -3.03823245359433E-18
      9.68314295356314E-09
      0.00000000000000E+00   9.20284266819418E-14   0.00000000000000E+00   1.26948450370595E-14  -4.80050385314969E-23
     -9.20835095012233E-11  -9.20708146562342E-11  -1.29435253958005E-18  -5.78751065370408E-03  -5.78751065413194E-03
      0.00000000000000E+00   0.00000000000000E+00   4.27850960709039E-10   0.00000000000000E+00   4.27850960709039E-10
      4.33706375724111E-18  -2.78312077403127E-01  -2.78206288650851E-01   0.00000000000000E+00  -9.15396699016191E-12
     -1.37265706541662E-22  -3.26626179062469E-10  -3.35780146052768E-10  -3.04271121766106E-18
      9.69852029731314E-09
      0.00000000000000E+00   8.90893950913009E-14   0.00000000000000E+00   1.26645398720974E-14  -4.80003172949017E-23
     -8.90872774005671E-11  -8.90746128607430E-11  -1.29484371334693E-18  -5.58933541679863E-03  -5.58933541722183E-03
      0.00000000000000E+00   0.00000000000000E+00   4.23200131753739E-10   0.00000000000000E+00   4.23200131753739E-10
      4.34357145114213E-18  -2.80438340737011E-01  -2.80333073315075E-01   0.00000000000000E+00  -9.17677119611131E-12
     -1.37545581245716E-22  -3.24948747696766E-10  -3.34125518893015E-10  -3.04872773779520E-18
      9.71927971137564E-09
      0.00000000000000E+00   8.56911398146225E-14   0.00000000000000E+00   1.13911606086435E-14  -4.79931737245428E-23
     -8.57197236200779E-11  -8.57083324595173E-11  -1.29544497113578E-18  -5.35319599979866E-03  -5.35319600021837E-03
      0.00000000000000E+00   0.00000000000000E+00   4.19705482084904E-10   0.00000000000000E+00   4.19705482084904E-10
      4.35228429102903E-18  -2.83347317880183E-01  -2.83242090906210E-01   0.00000000000000E+00  -9.30244478400059E-12
     -1.37925526893244E-22  -3.24694704841156E-10  -3.33997149625295E-10  -3.05683931989325E-18
      9.74730492036001E-09
      0.00000000000000E+00   8.10070582170386E-14   0.00000000000000E+00   1.20978442622283E-14  -4.79819480140327E-23
     -8.10500237841594E-11  -8.10379259399452E-11  -1.29614095313169E-18  -5.08849766297661E-03  -5.08849766340164E-03
      0.00000000000000E+00   0.00000000000000E+00   4.25026323257788E-10   0.00000000000000E+00   4.25026323257788E-10
      4.36419574256219E-18  -2.87554576743919E-01  -2.87446201727857E-01   0.00000000000000E+00  -1.01180046592811E-11
     -1.38477093228431E-22  -3.33870392658433E-10  -3.43988397317853E-10  -3.06805478943049E-18
      9.78513895248892E-09
      0.00000000000000E+00   7.33839450288139E-14   0.00000000000000E+00   1.47136133510349E-14  -4.79629348214948E-23
     -7.34276284528637E-11  -7.34129148395606E-11  -1.29682278649616E-18  -4.82879731469657E-03  -4.82879731516673E-03
      0.00000000000000E+00   0.00000000000000E+00   4.70162067409554E-10   0.00000000000000E+00   4.70162067409554E-10
      4.38198386932636E-18  -2.94858570826616E-01  -2.94733571950048E-01   0.00000000000000E+00  -1.37992883452968E-11
     -1.39475139522361E-22  -3.82949864224532E-10  -3.96749152569969E-10  -3.08516108283020E-18
      9.83513895248892E-09
      0.00000000000000E+00   6.36484028848160E-14   0.00000000000000E+00   1.55718180935828E-14  -4.79315005989368E-23
     -6.36340533100381E-11  -6.36184814919925E-11  -1.29729625248349E-18  -4.62784845759705E-03  -4.62784845814410E-03
      0.00000000000000E+00   0.00000000000000E+00   5.47046215218035E-10   0.00000000000000E+00   5.47046215218035E-10
      4.40933618008726E-18  -3.07958285714714E-01  -3.07805976237819E-01   0.00000000000000E+00  -2.00466912907049E-11
     -1.41349872481583E-22  -4.63381042435201E-10  -4.83427733726047E-10  -3.11203992760377E-18
      9.88513895248892E-09
      0.00000000000000E+00   5.27188791571204E-14   0.00000000000000E+00   1.79661723102547E-14  -4.78927821046794E-23
     -5.27575342625230E-11  -5.27395680902606E-11  -1.29729296065043E-18  -4.65618753498821E-03  -4.65618753555446E-03
      0.00000000000000E+00   0.00000000000000E+00   5.66253593635967E-10   0.00000000000000E+00   5.66253593635967E-10
      4.43764885976906E-18  -3.22479960002371E-01  -3.22318171044452E-01   0.00000000000000E+00  -2.29756064670796E-11
     -1.43444343503577E-22  -4.90538419078480E-10  -5.13514025545703E-10  -3.14035589911863E-18
      9.93513895248892E-09
      0.00000000000000E+00   1.57972947996946E-14   0.00000000000000E+00   4.93382368026980E-14  -4.78225901383014E-23
     -1.58217725007578E-11  -1.57724342640030E-11  -1.29551913080721E-18  -5.73399550755601E-03  -5.73399550805114E-03
      0.00000000000000E+00   0.00000000000000E+00   4.95128103550943E-10   0.00000000000000E+00   4.95128103550943E-10
      4.46240526494660E-18  -3.36771270603102E-01  -3.36620244476261E-01   0.00000000000000E+00  -2.14148688740749E-11
     -1.45349661030167E-22  -4.57940800412738E-10  -4.79355669286959E-10  -3.16688613413939E-18
      9.98513895248892E-09
      0.00000000000000E+00  -1.57421879573701E-13   0.00000000000000E+00   2.11128186462970E-13  -4.75973713202772E-23
      1.57263496195122E-10   1.57474624381537E-10  -1.28522954209105E-18  -1.18593586656790E-02  -1.18593586658692E-02
      0.00000000000000E+00   0.00000000000000E+00   1.90155349682736E-10   0.00000000000000E+00   1.90155349682736E-10
      4.47191303243074E-18  -3.50856825010840E-01  -3.50747303655876E-01   0.00000000000000E+00  -1.19809530569440E-11
     -1.46405926261317E-22  -3.35649021007154E-10  -3.47629974064244E-10  -3.18668349033969E-18
      1.00351389524889E-08
      0.00000000000000E+00  -6.84059602721659E-13   0.00000000000000E+00   6.34663469000537E-13  -4.69098283861721E-23
      6.83443702246626E-10   6.84078365715579E-10  -1.24917156868349E-18  -3.28796273843569E-02  -3.28796273836831E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.73802232053059E-10   0.00000000000000E+00  -6.73802232053059E-10
      4.43822292082808E-18  -3.65972095877053E-01  -3.65968870062156E-01   0.00000000000000E+00   1.41660107447497E-11
     -1.45212947125848E-22  -2.44421444071441E-11  -1.02761336625396E-11  -3.18905135214459E-18
      1.00601389524889E-08
      0.00000000000000E+00  -9.98168603971401E-13   0.00000000000000E+00   7.66611454022763E-13  -4.64411174747974E-23
      9.97470872360093E-10   9.98237483814069E-10  -1.22362501142511E-18  -4.74293871499642E-02  -4.74293871487938E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.17038395825442E-09   0.00000000000000E+00  -1.17038395825442E-09
      4.40896332187173E-18  -3.73725192149394E-01  -3.73779445724272E-01   0.00000000000000E+00   2.78682498938845E-11
     -1.44010349642849E-22   1.44278224546613E-10   1.72146474440354E-10  -3.18533831044662E-18
      1.00938889524889E-08
      0.00000000000000E+00  -1.23834259176908E-12   0.00000000000000E+00   5.07200581478426E-13  -4.57295552145188E-23
      1.23781543313448E-09   1.23832263371591E-09  -1.18232760756807E-18  -7.03296418387390E-02  -7.03296418372282E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.51071673135288E-09   0.00000000000000E+00  -1.51071673135288E-09
      4.35797663218857E-18  -3.83965409793908E-01  -3.84051251319153E-01   0.00000000000000E+00   3.57493276247216E-11
     -1.41865781711868E-22   2.36644770012414E-10   2.72394097636993E-10  -3.17564902462049E-18
      1.01052795774889E-08
      0.00000000000000E+00  -1.34029025006944E-12   0.00000000000000E+00   5.92759613710592E-13  -4.54814462954049E-23
      1.33965977628949E-09   1.34025253590316E-09  -1.16747320073996E-18  -7.83997675016551E-02  -7.83997675000144E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.64070455058368E-09   0.00000000000000E+00  -1.64070455058368E-09
      4.33928798191708E-18  -3.87359765594204E-01  -3.87454448381898E-01   0.00000000000000E+00   3.76225716624704E-11
     -1.41087341052209E-22   2.62829443018253E-10   3.00452014680582E-10  -3.17181478117711E-18
      1.01206569212389E-08
      0.00000000000000E+00  -1.42680799251893E-12   0.00000000000000E+00   4.26464000680799E-13  -4.51418306585752E-23
      1.42635301981068E-09   1.42677948381131E-09  -1.14669756643030E-18  -8.95317398648529E-02  -8.95317398631292E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.72362561636365E-09   0.00000000000000E+00  -1.72362561636365E-09
      4.31278319831795E-18  -3.91812379114389E-01  -3.91905927877884E-01   0.00000000000000E+00   3.86913725483582E-11
     -1.39986538864152E-22   2.58154760004070E-10   2.96846132552288E-10  -3.16608563188764E-18
      1.01414163353014E-08
      0.00000000000000E+00  -1.54703275352358E-12   0.00000000000000E+00   4.26958240216983E-13  -4.46465586506747E-23
      1.54663949279158E-09   1.54706645103175E-09  -1.11782584611978E-18  -1.04719268798305E-01  -1.04719268796504E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.80039621435418E-09   0.00000000000000E+00  -1.80039621435418E-09
      4.27540802782761E-18  -3.97503237388876E-01  -3.97583079490510E-01   0.00000000000000E+00   3.92856219921830E-11
     -1.38437592762748E-22   2.14044141330469E-10   2.53329763322514E-10  -3.15758218170783E-18
      1.01694415442858E-08
      0.00000000000000E+00  -1.76984808598904E-12   0.00000000000000E+00   5.22040582703266E-13  -4.37292236244388E-23
      1.76935500693358E-09   1.76987704751624E-09  -1.07784202285105E-18  -1.25233520861081E-01  -1.25233520859196E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.88569505735820E-09   0.00000000000000E+00  -1.88569505735820E-09
      4.22256102976434E-18  -4.04384559263717E-01  -4.04421084673539E-01   0.00000000000000E+00   3.97531903340287E-11
     -1.36237273672502E-22   7.60648195080641E-11   1.15818009841957E-10  -3.14471900691329E-18
      1.02072755764147E-08
      0.00000000000000E+00  -2.34516351985699E-12   0.00000000000000E+00   8.65821234139683E-13  -4.08525305525973E-23
      2.34431607145820E-09   2.34518189269230E-09  -1.02179903098805E-18  -1.53014687012757E-01  -1.53014687010710E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.04776126121154E-09   0.00000000000000E+00  -2.04776126121154E-09
      4.14508596441534E-18  -4.11311837720215E-01  -4.11218188383499E-01   0.00000000000000E+00   4.19215426945598E-11
     -1.32914308506827E-22  -3.39342174175203E-10  -2.97420631480776E-10  -3.12328693342728E-18
      1.02572755764147E-08
      0.00000000000000E+00  -4.00020568433662E-12   0.00000000000000E+00   1.72713416346144E-12  -2.78852270526186E-23
      3.99845801738322E-09   4.00018515154665E-09  -9.46725624433277E-19  -1.88532245977546E-01  -1.88532245975220E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.32560407232965E-09   0.00000000000000E+00  -2.32560407232965E-09
      4.02880576079885E-18  -4.11688446366681E-01  -4.11160961643488E-01   0.00000000000000E+00   4.77137742466428E-11
     -1.27431601141805E-22  -1.72229485346350E-09  -1.67458107921698E-09  -3.08208013636558E-18
      1.03072755764147E-08
      0.00000000000000E+00  -6.92187861964525E-12   0.00000000000000E+00   2.94746628630446E-12   4.18826225038153E-24
      6.91898556745933E-09   6.92193303374563E-09  -8.80364106136928E-19  -2.18551192884056E-01  -2.18551192881492E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.56413163812583E-09   0.00000000000000E+00  -2.56413163812583E-09
      3.90059917889256E-18  -3.95289259690407E-01  -3.93916467963419E-01   0.00000000000000E+00   5.36141676377635E-11
     -1.20506218871362E-22  -4.41141556325746E-09  -4.35780139561982E-09  -3.02023507275564E-18
      1.03572755764147E-08
      0.00000000000000E+00  -1.01809891194543E-11   0.00000000000000E+00   3.25520484819888E-12   4.39029224436426E-23
      1.01777622420461E-08   1.01810174468944E-08  -8.31188742374150E-19  -2.40364507292924E-01  -2.40364507290191E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.73338274271436E-09   0.00000000000000E+00  -2.73338274271436E-09
      3.76393004175684E-18  -3.57397060302826E-01  -3.55050815016066E-01   0.00000000000000E+00   5.63505141427681E-11
     -1.12536804695581E-22  -7.50398521832264E-09  -7.44763470417999E-09  -2.93274129938269E-18
      1.04072755764147E-08
      0.00000000000000E+00  -1.23061844936993E-11   0.00000000000000E+00   2.12027950772723E-12   7.14828980665200E-23
      1.23041096877220E-08   1.23062299672298E-08  -7.99452315093759E-19  -2.54783798798372E-01  -2.54783798795516E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.85604532688390E-09   0.00000000000000E+00  -2.85604532688390E-09
      3.62112777541265E-18  -3.01701021098017E-01  -2.98723817749794E-01   0.00000000000000E+00   5.18045113027649E-11
     -1.04624006499417E-22  -9.50198915164859E-09  -9.45018464034593E-09  -2.82167546031889E-18
      1.04572755764147E-08
      0.00000000000000E+00  -1.31611671523642E-11   0.00000000000000E+00   8.57821671642437E-13   8.27497718659782E-23
      1.31602753035417E-08   1.31611331252134E-08  -7.78623205915061E-19  -2.64868458127298E-01  -2.64868458124395E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90274791419172E-09   0.00000000000000E+00  -2.90274791419172E-09
      3.47599037970306E-18  -2.39703149842937E-01  -2.36471252574708E-01   0.00000000000000E+00   4.00497653547770E-11
     -9.64965566473743E-23  -1.02984349763764E-08  -1.02583852110217E-08  -2.69736717378800E-18
      1.04822755764147E-08
      0.00000000000000E+00  -1.32538384922066E-11   0.00000000000000E+00   1.93873842109633E-13   8.41056175952325E-23
      1.32536313852026E-08   1.32538252590448E-08  -7.70369397372873E-19  -2.69080524306142E-01  -2.69080524303225E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91734259446840E-09   0.00000000000000E+00  -2.91734259446840E-09
      3.40305681484135E-18  -2.08599566213755E-01  -2.05343031454454E-01   0.00000000000000E+00   3.16778440448423E-11
     -9.25261633550759E-23  -1.03681605086211E-08  -1.03364826645764E-08  -2.63268741746848E-18
      1.05160255764147E-08
      0.00000000000000E+00  -1.32789121054642E-11   0.00000000000000E+00   4.51877515355309E-14   8.31540125977105E-23
      1.32788075426655E-08   1.32788527304171E-08  -7.60538641470584E-19  -2.74308960077309E-01  -2.74308960074417E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.89114183333290E-09   0.00000000000000E+00  -2.89114183333290E-09
      3.30548077796637E-18  -1.68228529169509E-01  -1.64955820670416E-01   0.00000000000000E+00   2.55486050533704E-11
     -8.83473381419420E-23  -1.04132595021375E-08  -1.03877108970842E-08  -2.54494213649578E-18
      1.05388068264147E-08
      0.00000000000000E+00  -1.31772399813755E-11   0.00000000000000E+00  -2.12221128817466E-13   8.12340395839826E-23
      1.31774565973239E-08   1.31772443761952E-08  -7.54678159113391E-19  -2.77560662852847E-01  -2.77560662849967E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87949414854516E-09   0.00000000000000E+00  -2.87949414854516E-09
      3.23988230189482E-18  -1.41657493403017E-01  -1.38413108418357E-01   0.00000000000000E+00   2.15484081192655E-11
     -8.60056355731977E-23  -1.03192986357693E-08  -1.02977502276501E-08  -2.48520414278143E-18
      1.05541841701647E-08
      0.00000000000000E+00  -1.30751086336007E-11   0.00000000000000E+00  -3.20646567565189E-13   7.96326630994552E-23
      1.30753910500061E-08   1.30750704034386E-08  -7.50958993257400E-19  -2.79675801472314E-01  -2.79675801469446E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86838321213595E-09   0.00000000000000E+00  -2.86838321213595E-09
      3.19577418723508E-18  -1.24175409007342E-01  -1.20959702782459E-01   0.00000000000000E+00   1.91723948828308E-11
     -8.43644238437345E-23  -1.02258595861854E-08  -1.02066871913026E-08  -2.44481519397768E-18
      1.05749435842272E-08
      0.00000000000000E+00  -1.29428522120219E-11   0.00000000000000E+00  -3.07233014088980E-13   7.77355355925731E-23
      1.29431689415926E-08   1.29428617085786E-08  -7.45920544805134E-19  -2.82556967805784E-01  -2.82556967802942E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.84118803346570E-09   0.00000000000000E+00  -2.84118803346570E-09
      3.13679278841895E-18  -1.01701537437728E-01  -9.85189034324029E-02   0.00000000000000E+00   1.68747526175607E-11
     -8.16749608473330E-23  -1.01185484277303E-08  -1.01016736751128E-08  -2.39087224361381E-18
      1.06029687932116E-08
      0.00000000000000E+00  -1.26841255873083E-11   0.00000000000000E+00  -4.47640582159127E-13   7.57531410298336E-23
      1.26845222194803E-08   1.26840745788983E-08  -7.38695331796874E-19  -2.86626993699405E-01  -2.86626993696609E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.79527684644439E-09   0.00000000000000E+00  -2.79527684644439E-09
      3.05845457062816E-18  -7.40950551364896E-02  -7.09794748719372E-02   0.00000000000000E+00   1.40392419077923E-11
     -7.43056236967955E-23  -9.90283697436160E-09  -9.88879773245389E-09  -2.31975923883128E-18
      1.06408028253405E-08
      0.00000000000000E+00  -1.20026376372284E-11   0.00000000000000E+00  -8.77032174961683E-13   7.65536720322805E-23
      1.20035372856476E-08   1.20026602534727E-08  -7.25407191299977E-19  -2.93429764552853E-01  -2.93429764550167E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.68561366763437E-09   0.00000000000000E+00  -2.68561366763437E-09
      2.95684697684105E-18  -4.51756178139203E-02  -4.22401597996272E-02   0.00000000000000E+00   1.04010935051401E-11
     -4.41812369246481E-23  -9.32744767934344E-09  -9.31704658583835E-09  -2.23143978554107E-18
      1.06908028253405E-08
      0.00000000000000E+00  -1.07441810480109E-11   0.00000000000000E+00  -1.22426409341027E-12   8.86617078541345E-23
      1.07453827453777E-08   1.07441584812843E-08  -6.97821423681636E-19  -3.05993976010879E-01  -3.05993976008408E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.47002163075602E-09   0.00000000000000E+00  -2.47002163075602E-09
      2.83334589530324E-18  -2.45497433539777E-02  -2.19428568669395E-02   0.00000000000000E+00   6.52271171531482E-12
      2.95645883774459E-23  -8.28065956224366E-09  -8.27413685052832E-09  -2.13552447162161E-18
      1.07408028253405E-08
      0.00000000000000E+00  -9.72553106764221E-12   0.00000000000000E+00  -9.85854150219223E-13   1.06727769557143E-22
      9.72648644525051E-09   9.72550059110039E-09  -6.64628227247641E-19  -3.20429148049971E-01  -3.20429148047689E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.28236602316197E-09   0.00000000000000E+00  -2.28236602316197E-09
      2.71922759414515E-18  -1.54960337653804E-02  -1.31509605095076E-02   0.00000000000000E+00   4.02486056126694E-12
      9.85996012907176E-23  -7.44715942849980E-09  -7.44313456793843E-09  -2.05459936689751E-18
      1.07908028253405E-08
      0.00000000000000E+00  -9.10989579414016E-12   0.00000000000000E+00  -5.89599516848855E-13   1.21814892416070E-22
      9.11047537906923E-09   9.10988577955250E-09  -6.31291212713229E-19  -3.34793950765566E-01  -3.34793950763404E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.16185360452385E-09   0.00000000000000E+00  -2.16185360452385E-09
      2.61113491391896E-18  -1.12262211963313E-02  -9.03713385534170E-03   0.00000000000000E+00   2.71732248428754E-12
      1.48396334975274E-22  -6.95074949751307E-09  -6.94803217502863E-09  -1.97984370120572E-18
      1.08408028253405E-08
      0.00000000000000E+00  -8.77420327964665E-12   0.00000000000000E+00  -3.14948370073689E-13   1.30009429099705E-22
      8.77456362039406E-09   8.77424867202411E-09  -5.98845053851519E-19  -3.48813452768684E-01  -3.48813452766558E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.12569115848414E-09   0.00000000000000E+00  -2.12569115848414E-09
      2.50485035599475E-18  -8.86544830983519E-03  -6.77071262754870E-03   0.00000000000000E+00   2.09267175669663E-12
      1.78793212279649E-22  -6.65065018529687E-09  -6.64855751353999E-09  -1.90600530214323E-18
      1.08908028253405E-08
      0.00000000000000E+00  -8.77255007437692E-12   0.00000000000000E+00   1.42362584589302E-14   1.32206409071995E-22
      8.77256099510443E-09   8.77257523136302E-09  -5.64443039679449E-19  -3.63678416713223E-01  -3.63678416710941E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.28196572789550E-09   0.00000000000000E+00  -2.28196572789550E-09
      2.39075206959997E-18  -7.38526886729452E-03  -5.34029517828674E-03   0.00000000000000E+00   1.84607060563468E-12
      1.94195001356958E-22  -6.49245557407332E-09  -6.49060950346749E-09  -1.82630902992052E-18
      1.09158028253405E-08
      0.00000000000000E+00  -8.83821906148030E-12   0.00000000000000E+00   1.45243848903991E-13   1.30407890526336E-22
      8.83807910173936E-09   8.83822434558840E-09  -5.46494598497536E-19  -3.71406938983477E-01  -3.71406938981068E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40931914355797E-09   0.00000000000000E+00  -2.40931914355797E-09
      2.33051909101102E-18  -6.82404211360810E-03  -4.79850839534122E-03   0.00000000000000E+00   1.75613991774935E-12
      1.95741166451278E-22  -6.43066134194842E-09  -6.42890520203048E-09  -1.78402449251349E-18
      1.09495528253405E-08
      0.00000000000000E+00  -8.84014780096166E-12   0.00000000000000E+00   1.82535582386431E-14   1.23557708501763E-22
      8.84014926494656E-09   8.84016751850492E-09  -5.22470243697465E-19  -3.81754364600748E-01  -3.81754364598310E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43861928815527E-09   0.00000000000000E+00  -2.43861928815527E-09
      2.24821569003578E-18  -6.21180263270980E-03  -4.19488685316834E-03   0.00000000000000E+00   1.58396370729451E-12
      1.89415948004043E-22  -6.40313219405715E-09  -6.40154823034966E-09  -1.72574544633832E-18
      1.09723340753405E-08
      0.00000000000000E+00  -8.79018426392076E-12   0.00000000000000E+00  -9.38076604815746E-14   1.15940724358579E-22
      8.79026160941609E-09   8.79016780175572E-09  -5.06751982899856E-19  -3.88521645671886E-01  -3.88521645669476E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41048743680296E-09   0.00000000000000E+00  -2.41048743680296E-09
      2.19330177311612E-18  -5.85994002686081E-03  -3.84991322234641E-03   0.00000000000000E+00   1.47565231390419E-12
      1.79474832056599E-22  -6.38115601726680E-09  -6.37968036495271E-09  -1.68654979021626E-18
      1.09877114190905E-08
      0.00000000000000E+00  -8.73516926633345E-12   0.00000000000000E+00  -1.62794535353848E-13   1.09563815843417E-22
      8.73531833728265E-09   8.73515554274741E-09  -4.96463960203516E-19  -3.92949820382162E-01  -3.92949820379796E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.36654855636483E-09   0.00000000000000E+00  -2.36654855636483E-09
      2.15691054246383E-18  -5.65002367380744E-03  -3.64348515642522E-03   0.00000000000000E+00   1.37958713538436E-12
      1.70403368008660E-22  -6.36998657351812E-09  -6.36860698638256E-09  -1.66044658226031E-18
      1.10084708331530E-08
      0.00000000000000E+00  -8.62945597380759E-12   0.00000000000000E+00  -2.38596047848321E-13   9.98452445888031E-23
      8.62965631599079E-09   8.62941771994304E-09  -4.83325230719695E-19  -3.98603527336619E-01  -3.98603527334355E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26361881132384E-09   0.00000000000000E+00  -2.26361881132384E-09
      2.10991914227989E-18  -5.40456111538061E-03  -3.39890660950002E-03   0.00000000000000E+00   1.24623568306076E-12
      1.55957963741887E-22  -6.36704514430237E-09  -6.36579890861916E-09  -1.62659391156020E-18
      1.10364960421374E-08
      0.00000000000000E+00  -8.42179502298137E-12   0.00000000000000E+00  -3.54280472125644E-13   8.55424241214297E-23
      8.42218240024564E-09   8.42182811977360E-09  -4.67483275578795E-19  -4.05419290536764E-01  -4.05419290534712E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.05211511892444E-09   0.00000000000000E+00  -2.05211511892444E-09
      2.05240818721204E-18  -5.12760486184872E-03  -3.12071626310670E-03   0.00000000000000E+00   1.06689447934212E-12
      1.33882437502730E-22  -6.37077989532869E-09  -6.36971300084921E-09  -1.58492491163325E-18
      1.10743300742663E-08
      0.00000000000000E+00  -7.96321425010419E-12   0.00000000000000E+00  -5.89610625650510E-13   6.59457859826307E-23
      7.96388242073577E-09   7.96329281011019E-09  -4.51830705948605E-19  -4.12193603887641E-01  -4.12193603886085E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55532294599949E-09   0.00000000000000E+00  -1.55532294599949E-09
      1.99356404890227E-18  -4.85102474063629E-03  -2.83208160898498E-03   0.00000000000000E+00   7.13039934267962E-13
      1.02686428500386E-22  -6.40868290404502E-09  -6.40796986411065E-09  -1.54173334295366E-18
      1.11243300742663E-08
      0.00000000000000E+00  -6.62430167109287E-12   0.00000000000000E+00  -1.31989625476019E-12   4.17776295325325E-23
      6.62559908492885E-09   6.62427918867414E-09  -4.53025830687697E-19  -4.12116221885821E-01  -4.12116221885687E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.34209255603264E-10   0.00000000000000E+00  -1.34209255603264E-10
      1.98685358612211E-18  -4.63051052795422E-03  -2.58569941363514E-03   0.00000000000000E+00  -1.03707516163235E-13
      6.31888456329908E-23  -6.48996622555481E-09  -6.49006993307091E-09  -1.53382775543441E-18
      1.11743300742663E-08
      0.00000000000000E+00  -4.10362285843230E-12   0.00000000000000E+00  -2.51658527121329E-12   1.79453650753530E-23
      4.10614914072198E-09   4.10363255545079E-09  -4.96321577193431E-19  -3.95001614141215E-01  -3.95001614143634E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41935490266111E-09   0.00000000000000E+00   2.41935490266111E-09
      2.10782133125516E-18  -4.59070853019327E-03  -2.53552090093446E-03   0.00000000000000E+00  -1.59853344100902E-12
      2.27162143084658E-23  -6.52138892467086E-09  -6.52298745811185E-09  -1.61149975406173E-18
      1.12243300742663E-08
      0.00000000000000E+00  -1.35223006590642E-12   0.00000000000000E+00  -2.75451014162613E-12  -1.03194596171552E-23
      1.35493586413308E-09   1.35218135399144E-09  -5.93083981346420E-19  -3.56364932869978E-01  -3.56364932875089E-01
      0.00000000000000E+00   0.00000000000000E+00   5.11103831368046E-09   0.00000000000000E+00   5.11103831368046E-09
      2.36337324693918E-18  -5.34102533644940E-03  -3.30467533168485E-03   0.00000000000000E+00  -4.21004472218190E-12
     -2.82979187640857E-23  -6.45900962294972E-09  -6.46321966767193E-09  -1.77028926559276E-18
      1.12743300742663E-08
      0.00000000000000E+00   3.23477164444909E-13   0.00000000000000E+00  -1.73348993085996E-12  -3.34860503230899E-23
     -3.21694599310867E-10  -3.23428089241761E-10  -7.28482420126788E-19  -3.00186442535869E-01  -3.00186442542373E-01
      0.00000000000000E+00   0.00000000000000E+00   6.50338571743591E-09   0.00000000000000E+00   6.50338571743591E-09
      2.68854253281098E-18  -9.93204723682563E-03  -7.98494710953361E-03   0.00000000000000E+00  -8.47038797471170E-12
     -6.89300726814884E-23  -6.17148724021931E-09  -6.17995762819409E-09  -1.96006011268419E-18
      1.13243300742663E-08
      0.00000000000000E+00   1.43764567150942E-12   0.00000000000000E+00  -1.21843104963698E-12  -4.12664548704076E-23
     -1.43638555962265E-09  -1.43760399067232E-09  -8.65843107398664E-19  -2.38092672467974E-01  -2.38092672474634E-01
      0.00000000000000E+00   0.00000000000000E+00   6.65935221923031E-09   0.00000000000000E+00   6.65935221923031E-09
      3.02151014377250E-18  -2.79610561471221E-02  -2.63158581718970E-02   0.00000000000000E+00  -1.57260059427920E-11
     -8.10182108708611E-23  -5.20602222261515E-09  -5.22174822855802E-09  -2.15566703637383E-18
      1.13493300742663E-08
      0.00000000000000E+00   1.87133652060336E-12   0.00000000000000E+00  -1.00323183887329E-12  -4.25850219885909E-23
     -1.87030176024251E-09  -1.87130499208142E-09  -9.30111708875857E-19  -2.06995451432359E-01  -2.06995451438775E-01
      0.00000000000000E+00   0.00000000000000E+00   6.41527956435869E-09   0.00000000000000E+00   6.41527956435869E-09
      3.18189213288146E-18  -4.15036984096648E-02  -4.00720409707105E-02   0.00000000000000E+00  -2.35907189329589E-11
     -8.50089381308801E-23  -4.52038385334425E-09  -4.54397457227730E-09  -2.25178042400561E-18
      1.13830800742663E-08
      0.00000000000000E+00   2.13309402164481E-12   0.00000000000000E+00  -5.48967004749073E-13  -4.37345119134621E-23
     -2.13250316991384E-09  -2.13305213691863E-09  -1.00963799755790E-18  -1.66664304911697E-01  -1.66664304917751E-01
      0.00000000000000E+00   0.00000000000000E+00   6.05445496401036E-09   0.00000000000000E+00   6.05445496401036E-09
      3.38622998791681E-18  -6.38158568291126E-02  -6.25803497320748E-02   0.00000000000000E+00  -3.22676726167612E-11
     -9.13737896784891E-23  -3.88913515447487E-09  -3.92140282709172E-09  -2.37659199035891E-18
      1.14058613242663E-08
      0.00000000000000E+00   2.12978761110534E-12   0.00000000000000E+00  -1.80654331533397E-13  -4.44791439865165E-23
     -2.12958338678270E-09  -2.12976404111428E-09  -1.05989128082708E-18  -1.40138085771390E-01  -1.40138085777085E-01
      0.00000000000000E+00   0.00000000000000E+00   5.69553666730010E-09   0.00000000000000E+00   5.69553666730010E-09
      3.51598143261874E-18  -7.99302022145005E-02  -7.88067393401180E-02   0.00000000000000E+00  -4.12486289453192E-11
     -9.58631414474012E-23  -3.52452399724040E-09  -3.56577262618581E-09  -2.45609015179166E-18
      1.14212386680163E-08
      0.00000000000000E+00   2.07385416614595E-12   0.00000000000000E+00  -2.12488368886971E-14  -4.49846313284093E-23
     -2.07381576939232E-09  -2.07383701822925E-09  -1.09209092271429E-18  -1.22697430917903E-01  -1.22697430923331E-01
      0.00000000000000E+00   0.00000000000000E+00   5.42801051149305E-09   0.00000000000000E+00   5.42801051149305E-09
      3.59944981613258E-18  -9.10897133101305E-02  -9.00329162089805E-02   0.00000000000000E+00  -4.76299388879067E-11
     -9.89134936551836E-23  -3.30654355437577E-09  -3.35417349326378E-09  -2.50735889341829E-18
      1.14419980820788E-08
      0.00000000000000E+00   1.96979407888983E-12   0.00000000000000E+00   4.03972696821969E-14  -4.56449355918738E-23
     -1.96979130302824E-09  -1.96975090575861E-09  -1.13249444336835E-18  -1.00301327189063E-01  -1.00301327194159E-01
      0.00000000000000E+00   0.00000000000000E+00   5.09612419677265E-09   0.00000000000000E+00   5.09612419677265E-09
      3.70524236844731E-18  -1.06300746483742E-01  -1.05315721662567E-01   0.00000000000000E+00  -5.30103954993482E-11
     -1.03006719159999E-22  -3.07336289551455E-09  -3.12637329101400E-09  -2.57274792507896E-18
      1.14700232910631E-08
      0.00000000000000E+00   1.76746012282164E-12   0.00000000000000E+00   1.48782535560299E-13  -4.64481623395041E-23
     -1.76764950673250E-09  -1.76750072419698E-09  -1.18060625686630E-18  -7.28686165256075E-02  -7.28686165302094E-02
      0.00000000000000E+00   0.00000000000000E+00   4.60186551520803E-09   0.00000000000000E+00   4.60186551520803E-09
      3.83421061122901E-18  -1.26844680563442E-01  -1.25951658531466E-01   0.00000000000000E+00  -5.88946077953447E-11
     -1.08459196968373E-22  -2.77547018321563E-09  -2.83436479101109E-09  -2.65360435436271E-18
      1.15078573231921E-08
      0.00000000000000E+00   1.34313743692287E-12   0.00000000000000E+00   3.77567375295660E-13  -4.72458683988612E-23
     -1.34351167902425E-09  -1.34313411164900E-09  -1.22906934550245E-18  -4.43520447691927E-02  -4.43520447729234E-02
      0.00000000000000E+00   0.00000000000000E+00   3.73069240161056E-09   0.00000000000000E+00   3.73069240161056E-09
      3.97535774741461E-18  -1.54688695192515E-01  -1.53936448447457E-01   0.00000000000000E+00  -6.19418901335628E-11
     -1.15337524539703E-22  -2.32561639982790E-09  -2.38755828996158E-09  -2.74628840191216E-18
      1.15578573231921E-08
      0.00000000000000E+00   7.29706437113800E-13   0.00000000000000E+00   5.07877812695159E-13  -4.77512138320317E-23
     -7.30257397928691E-10  -7.29749520116044E-10  -1.26237127418578E-18  -2.41852980689759E-02  -2.41852980714626E-02
      0.00000000000000E+00   0.00000000000000E+00   2.48669467286029E-09   0.00000000000000E+00   2.48669467286029E-09
      4.09969248105762E-18  -1.90102552855883E-01  -1.89548993307511E-01   0.00000000000000E+00  -5.62258940667523E-11
     -1.22686831401873E-22  -1.70071925867738E-09  -1.75694515274426E-09  -2.83732120687184E-18
      1.16078573231921E-08
      0.00000000000000E+00   3.51214275081582E-13   0.00000000000000E+00   3.35166128038862E-13  -4.79332394543672E-23
     -3.51501952146749E-10  -3.51166786018758E-10  -1.27680052995831E-18  -1.53358256614893E-02  -1.53358256630685E-02
      0.00000000000000E+00   0.00000000000000E+00   1.57915130300044E-09   0.00000000000000E+00   1.57915130300044E-09
      4.17865004620764E-18  -2.19781883232502E-01  -2.19394983129877E-01   0.00000000000000E+00  -4.53705244417832E-11
     -1.28066898958829E-22  -1.18261399253977E-09  -1.22798451698168E-09  -2.90184951624933E-18
      1.16578573231921E-08
      0.00000000000000E+00   2.01782887644936E-13   0.00000000000000E+00   1.33855509736216E-13  -4.79983404843668E-23
     -2.01872763125624E-10  -2.01738907615936E-10  -1.28382266671618E-18  -1.11430228484612E-02  -1.11430228495105E-02
      0.00000000000000E+00   0.00000000000000E+00   1.04929786660926E-09   0.00000000000000E+00   1.04929786660926E-09
      4.23111493953811E-18  -2.41212717403657E-01  -2.40945679064360E-01   0.00000000000000E+00  -3.27000994452395E-11
     -1.31697818743916E-22  -8.14858859547940E-10  -8.47558958993311E-10  -2.94729227282193E-18
      1.17078573231921E-08
      0.00000000000000E+00   1.44471771627440E-13   0.00000000000000E+00   5.20530098725109E-14  -4.80209516040268E-23
     -1.44522715835892E-10  -1.44470662826068E-10  -1.28803683804579E-18  -8.81522827781104E-03  -8.81522827854181E-03
      0.00000000000000E+00   0.00000000000000E+00   7.30773463475416E-10   0.00000000000000E+00   7.30773463475416E-10
      4.26765361271188E-18  -2.55347563480142E-01  -2.55162840624157E-01   0.00000000000000E+00  -2.13499283071907E-11
     -1.33976524695517E-22  -5.64952872342063E-10  -5.86302800649387E-10  -2.97961677466609E-18
      1.17578573231921E-08
      0.00000000000000E+00   1.17561263625634E-13   0.00000000000000E+00   2.60117630978853E-14  -4.80242943242326E-23
     -1.17601433706480E-10  -1.17575421943430E-10  -1.29095575545703E-18  -7.35175908416728E-03  -7.35175908472872E-03
      0.00000000000000E+00   0.00000000000000E+00   5.61437801252908E-10   0.00000000000000E+00   5.61437801252908E-10
      4.29572550277452E-18  -2.65296380896504E-01  -2.65156537811067E-01   0.00000000000000E+00  -1.44805583236475E-11
     -1.35482395282774E-22  -4.29381820985655E-10  -4.43862379309438E-10  -3.00476974731750E-18
      1.17828573231921E-08
      0.00000000000000E+00   1.06448050423524E-13   0.00000000000000E+00   2.30959299333771E-14  -4.80218159993932E-23
     -1.06429576637270E-10  -1.06406480707385E-10  -1.29214784035916E-18  -6.79558432431240E-03  -6.79558432480767E-03
      0.00000000000000E+00   0.00000000000000E+00   4.95270690898166E-10   0.00000000000000E+00   4.95270690898166E-10
      4.30810727004698E-18  -2.69464735569279E-01  -2.69342221171579E-01   0.00000000000000E+00  -1.17229413222036E-11
     -1.36083244099020E-22  -3.77141268868508E-10  -3.88864210190847E-10  -3.01595942968782E-18
      1.18166073231921E-08
      0.00000000000000E+00   9.85494030236762E-14   0.00000000000000E+00   1.34385859206894E-14  -4.80154605248947E-23
     -9.85810815308283E-11  -9.85676429449556E-11  -1.29351392445004E-18  -6.18869087209101E-03  -6.18869087255341E-03
      0.00000000000000E+00   0.00000000000000E+00   4.62397229692066E-10   0.00000000000000E+00   4.62397229692066E-10
      4.32371317654908E-18  -2.74656171736538E-01  -2.74541545221058E-01   0.00000000000000E+00  -1.05863053291860E-11
     -1.36804908105112E-22  -3.53243281417796E-10  -3.63829586747119E-10  -3.03019925209905E-18
      1.18393885731921E-08
      0.00000000000000E+00   9.37734766888848E-14   0.00000000000000E+00   1.28535455316718E-14  -4.80098094457274E-23
     -9.38022076623749E-11  -9.37893541168913E-11  -1.29433674315445E-18  -5.83999383281015E-03  -5.83999383324752E-03
      0.00000000000000E+00   0.00000000000000E+00   4.37372621483163E-10   0.00000000000000E+00   4.37372621483163E-10
      4.33367707158225E-18  -2.77892118468011E-01  -2.77783871144633E-01   0.00000000000000E+00  -9.55844024466801E-12
     -1.37240753989529E-22  -3.34024827121451E-10  -3.43583267366256E-10  -3.03934032842780E-18
      1.18547659169421E-08
      0.00000000000000E+00   9.04670661494139E-14   0.00000000000000E+00   1.34754723252140E-14  -4.80053317159909E-23
     -9.05017087924081E-11  -9.04882333201309E-11  -1.29484573033997E-18  -5.63198694911467E-03  -5.63198694953913E-03
      0.00000000000000E+00   0.00000000000000E+00   4.24458225968555E-10   0.00000000000000E+00   4.24458225968555E-10
      4.34020411163048E-18  -2.80000948697800E-01  -2.79895730309937E-01   0.00000000000000E+00  -9.10620192443927E-12
     -1.37519090757575E-22  -3.24863790723816E-10  -3.33969992648393E-10  -3.04535838129051E-18
      1.18755253310046E-08
      0.00000000000000E+00   8.66095871866977E-14   0.00000000000000E+00   1.24370506889501E-14  -4.79983405352737E-23
     -8.66595214130139E-11  -8.66470843623729E-11  -1.29546114790362E-18  -5.38878599234755E-03  -5.38878599276705E-03
      0.00000000000000E+00   0.00000000000000E+00   4.19502810777450E-10   0.00000000000000E+00   4.19502810777450E-10
      4.34891274417979E-18  -2.82880617942430E-01  -2.82775750628837E-01   0.00000000000000E+00  -9.19520881061796E-12
     -1.37895110716354E-22  -3.23660517604357E-10  -3.32855726415113E-10  -3.05345159627618E-18
      1.19035505399889E-08
      0.00000000000000E+00   8.21091950635289E-14   0.00000000000000E+00   1.17958317256792E-14  -4.79874313234576E-23
     -8.21039456226619E-11  -8.20921497909842E-11  -1.29617933060958E-18  -5.11463099505258E-03  -5.11463099547397E-03
      0.00000000000000E+00   0.00000000000000E+00   4.21390241682470E-10   0.00000000000000E+00   4.21390241682470E-10
      4.36072229376692E-18  -2.86973829631103E-01  -2.86866932458324E-01   0.00000000000000E+00  -9.78240884903621E-12
     -1.38429254393814E-22  -3.29515683042400E-10  -3.39298091891574E-10  -3.06454296315734E-18
      1.19413845721178E-08
      0.00000000000000E+00   7.47616160869268E-14   0.00000000000000E+00   1.41343575995860E-14  -4.79690748596976E-23
     -7.48073854298999E-11  -7.47932510723483E-11  -1.29690279249124E-18  -4.84153757731401E-03  -4.84153757777259E-03
      0.00000000000000E+00   0.00000000000000E+00   4.58580682491941E-10   0.00000000000000E+00   4.58580682491941E-10
      4.37807225004202E-18  -2.93888319396012E-01  -2.93767404520045E-01   0.00000000000000E+00  -1.29139908060651E-11
     -1.39365107118438E-22  -3.70873440613401E-10  -3.83787431419605E-10  -3.08116945755078E-18
      1.19913845721178E-08
      0.00000000000000E+00   6.48423844685139E-14   0.00000000000000E+00   1.55609114301186E-14  -4.79383611342041E-23
     -6.48927933967327E-11  -6.48772324853505E-11  -1.29742421870669E-18  -4.62404906340520E-03  -4.62404906394349E-03
      0.00000000000000E+00   0.00000000000000E+00   5.38291408719435E-10   0.00000000000000E+00   5.38291408719435E-10
      4.40498682047799E-18  -3.06585387227173E-01  -3.06436232827559E-01   0.00000000000000E+00  -1.93108359142267E-11
     -1.41174328891694E-22  -4.54103340319720E-10  -4.73414176234088E-10  -3.10756260177130E-18
      1.20413845721178E-08
      0.00000000000000E+00   5.51986870617236E-14   0.00000000000000E+00   1.64762201374702E-14  -4.79014296996439E-23
     -5.51878657569095E-11  -5.51713895368200E-11  -1.29752683600215E-18  -4.59169618540204E-03  -4.59169618597088E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68838021295463E-10   0.00000000000000E+00   5.68838021295463E-10
      4.43342872154276E-18  -3.21044629131621E-01  -3.20882792085249E-01   0.00000000000000E+00  -2.28984879445735E-11
     -1.43265807794063E-22  -4.90768143813898E-10  -5.13666631758615E-10  -3.13590188554061E-18
      1.20913845721178E-08
      0.00000000000000E+00   2.59002158925225E-14   0.00000000000000E+00   4.01822286537568E-14  -4.78400964457114E-23
     -2.59182030627166E-11  -2.58780208341107E-11  -1.29623945245087E-18  -5.37853191154157E-03  -5.37853191205575E-03
      0.00000000000000E+00   0.00000000000000E+00   5.14181705834104E-10   0.00000000000000E+00   5.14181705834104E-10
      4.45913780683447E-18  -3.35389921116900E-01  -3.35236075622548E-01   0.00000000000000E+00  -2.19979123378228E-11
     -1.45225737930794E-22  -4.66305772662027E-10  -4.88303684999995E-10  -3.16289835438359E-18
      1.21413845721178E-08
      0.00000000000000E+00  -1.10672908335070E-13   0.00000000000000E+00   1.67637117273864E-13  -4.76568465493386E-23
      1.10509167206541E-10   1.10676804323767E-10  -1.28824961667928E-18  -1.01464411948097E-02  -1.01464411950786E-02
      0.00000000000000E+00   0.00000000000000E+00   2.68945337245902E-10   0.00000000000000E+00   2.68945337245902E-10
      4.47258507369676E-18  -3.49409907410095E-01  -3.49290305825820E-01   0.00000000000000E+00  -1.44240568734449E-11
     -1.46492388368648E-22  -3.65198084696078E-10  -3.79622141569669E-10  -3.18433545701748E-18
      1.21913845721178E-08
      0.00000000000000E+00  -5.89459523397907E-13   0.00000000000000E+00   5.75326834611836E-13  -4.70497163838614E-23
      5.88873344282334E-10   5.89448671116899E-10  -1.25677231919680E-18  -2.85728912702852E-02  -2.85728912697634E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.21732660157903E-10   0.00000000000000E+00  -5.21732660157903E-10
      4.44649844068887E-18  -3.64317559367098E-01  -3.64296235017178E-01   0.00000000000000E+00   9.74809928759902E-12
     -1.45682014088903E-22  -7.74641102464687E-11  -6.77160109590154E-11  -3.18972612149206E-18
      1.22163845721178E-08
      0.00000000000000E+00  -9.25611261577455E-13   0.00000000000000E+00   8.03259230898976E-13  -4.66053915352767E-23
      9.24763140714887E-10   9.25566399945739E-10  -1.23290291867009E-18  -4.22577299726893E-02  -4.22577299716304E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.05888394184485E-09   0.00000000000000E+00  -1.05888394184485E-09
      4.42002634214275E-18  -3.72050287943844E-01  -3.72092306666528E-01   0.00000000000000E+00   2.50994520297588E-11
     -1.44608461408678E-22   1.08218089869496E-10   1.33317541899110E-10  -3.18712342347266E-18
      1.22501345721178E-08
      0.00000000000000E+00  -1.19030779420955E-12   0.00000000000000E+00   5.43691007641979E-13  -4.59039238421651E-23
      1.18978083221474E-09   1.19032452322233E-09  -1.19281082802034E-18  -6.46572937170300E-02  -6.46572937155797E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.45033159609799E-09   0.00000000000000E+00  -1.45033159609799E-09
      4.37107765077444E-18  -3.82376810814133E-01  -3.82458748863567E-01   0.00000000000000E+00   3.47423105092403E-11
     -1.42545676458500E-22   2.25264762366576E-10   2.60007072875674E-10  -3.17826682275410E-18
      1.22729158221178E-08
      0.00000000000000E+00  -1.34552540009027E-12   0.00000000000000E+00   4.88973183830718E-13  -4.54096896077069E-23
      1.34501327633015E-09   1.34550224951393E-09  -1.16314660936832E-18  -8.08000441431727E-02  -8.08000441415313E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.64139852818469E-09   0.00000000000000E+00  -1.64139852818469E-09
      4.33368454055423E-18  -3.89121298907413E-01  -3.89214546923706E-01   0.00000000000000E+00   3.79662124849881E-11
     -1.40979189268775E-22   2.57930066185925E-10   2.95896278670772E-10  -3.17053793118591E-18
      1.22882931658678E-08
      0.00000000000000E+00  -1.44609538733251E-12   0.00000000000000E+00   4.70025974853722E-13  -4.50664765087848E-23
      1.44565272002432E-09   1.44612274599913E-09  -1.14223299841453E-18  -9.19691986593314E-02  -9.19691986575915E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.73985688157475E-09   0.00000000000000E+00  -1.73985688157475E-09
      4.30693016321045E-18  -3.93530374337634E-01  -3.93622943216085E-01   0.00000000000000E+00   3.90085909545642E-11
     -1.39867063542209E-22   2.54725544621172E-10   2.93734135575597E-10  -3.16469716479592E-18
      1.23090525799303E-08
      0.00000000000000E+00  -1.57091238519754E-12   0.00000000000000E+00   4.36364076355583E-13  -4.45589717186433E-23
      1.57045730836975E-09   1.57089367244606E-09  -1.11321121422273E-18  -1.07183887542614E-01  -1.07183887540799E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.81455359699015E-09   0.00000000000000E+00  -1.81455359699015E-09
      4.26926109375194E-18  -3.99150881001908E-01  -3.99227677335479E-01   0.00000000000000E+00   3.95235301570151E-11
     -1.38304470126971E-22   2.04136394387271E-10   2.43659924544148E-10  -3.15604987952921E-18
      1.23370777889147E-08
      0.00000000000000E+00  -1.80805549666737E-12   0.00000000000000E+00   5.46091825272079E-13  -4.35833261736730E-23
      1.80757120259210E-09   1.80811729441733E-09  -1.07302552796120E-18  -1.27730623924818E-01  -1.27730623922916E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.90167450870326E-09   0.00000000000000E+00  -1.90167450870326E-09
      4.21596626822527E-18  -4.05902560537610E-01  -4.05932073847776E-01   0.00000000000000E+00   4.00439294185566E-11
     -1.36080800477175E-22   5.35132848675058E-11   9.35572142859264E-11  -3.14294074026407E-18
      1.23749118210436E-08
      0.00000000000000E+00  -2.42598688859961E-12   0.00000000000000E+00   9.20171508370518E-13  -4.04242276694792E-23
      2.42509425248114E-09   2.42601442398947E-09  -1.01663205367542E-18  -1.55584559202008E-01  -1.55584559199935E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.07281582682036E-09   0.00000000000000E+00  -2.07281582682036E-09
      4.13754328763604E-18  -4.12516583538606E-01  -4.12405363631378E-01   0.00000000000000E+00   4.24618277963197E-11
     -1.32701045038083E-22  -3.95660424965310E-10  -3.53198597169123E-10  -3.12091123396062E-18
      1.24249118210436E-08
      0.00000000000000E+00  -4.17021029290775E-12   0.00000000000000E+00   1.81334054448588E-12  -2.64205878322635E-23
      4.16841504398662E-09   4.17022838453108E-09  -9.41670054026510E-19  -1.90920498639816E-01  -1.90920498637468E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.34872395213184E-09   0.00000000000000E+00  -2.34872395213184E-09
      4.02010709002945E-18  -4.11959999446863E-01  -4.11386230257559E-01   0.00000000000000E+00   4.83692017625610E-11
     -1.27110851204032E-22  -1.86987363416165E-09  -1.82150443239922E-09  -3.07843703600294E-18
      1.24749118210436E-08
      0.00000000000000E+00  -7.16352212323826E-12   0.00000000000000E+00   3.01603848990416E-12   6.75218252076771E-24
      7.16051189021109E-09   7.16352792870100E-09  -8.76289501823223E-19  -2.20417808269597E-01  -2.20417808267019E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.57846743209757E-09   0.00000000000000E+00  -2.57846743209757E-09
      3.89118371842457E-18  -3.94099649308294E-01  -3.92655262100566E-01   0.00000000000000E+00   5.41423907318523E-11
     -1.20072747474050E-22  -4.63920288733517E-09  -4.58506049660344E-09  -3.01489421660135E-18
      1.25249118210436E-08
      0.00000000000000E+00  -1.03878234676457E-11   0.00000000000000E+00   3.21943484148506E-12   4.59713315854114E-23
      1.03845781503640E-08   1.03877975852056E-08  -8.28404971410092E-19  -2.41653520025302E-01  -2.41653520022559E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74340980456720E-09   0.00000000000000E+00  -2.74340980456720E-09
      3.75401322819621E-18  -3.54703515338188E-01  -3.52295281423682E-01   0.00000000000000E+00   5.64811150153944E-11
     -1.12055733766974E-22  -7.70086889565360E-09  -7.64438778063832E-09  -2.92560825678612E-18
      1.25749118210436E-08
      0.00000000000000E+00  -1.24079484625252E-11   0.00000000000000E+00   2.01581025860974E-12   7.22189796316709E-23
      1.24059870242716E-08   1.24080028345303E-08  -7.97700367582313E-19  -2.55648456212082E-01  -2.55648456209220E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86194709367199E-09   0.00000000000000E+00  -2.86194709367199E-09
      3.61091587351261E-18  -2.98079815360299E-01  -2.95072403653327E-01   0.00000000000000E+00   5.13422923303642E-11
     -1.04137352045185E-22  -9.59739803318861E-09  -9.54605574085835E-09  -2.81321550593030E-18
      1.26249118210436E-08
      0.00000000000000E+00  -1.31970784446123E-11   0.00000000000000E+00   7.92466045072402E-13   8.24869633119522E-23
      1.31963273058537E-08   1.31971197718988E-08  -7.77374117130200E-19  -2.65535665545044E-01  -2.65535665542141E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90291851034314E-09   0.00000000000000E+00  -2.90291851034314E-09
      3.46576994799546E-18  -2.35972756733023E-01  -2.32729571480342E-01   0.00000000000000E+00   3.92764488214211E-11
     -9.59889860512775E-23  -1.03334777103770E-08  -1.02942012615556E-08  -2.68839583086525E-18
      1.26499118210436E-08
      0.00000000000000E+00  -1.32666967554156E-11   0.00000000000000E+00   1.47798534042217E-13   8.34814581635579E-23
      1.32664606562885E-08   1.32666084548227E-08  -7.69286682198705E-19  -2.69684393010536E-01  -2.69684393007620E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91563664023868E-09   0.00000000000000E+00  -2.91563664023868E-09
      3.39287903198949E-18  -2.04916900950346E-01  -2.01655797849792E-01   0.00000000000000E+00   3.10275384997991E-11
     -9.20842866164329E-23  -1.03819993530837E-08  -1.03509718145840E-08  -2.62359234979079E-18
      1.26836618210436E-08
      0.00000000000000E+00  -1.32736769554434E-11   0.00000000000000E+00   1.87922469322229E-14   8.22706916103320E-23
      1.32736812053073E-08   1.32736999975543E-08  -7.59603737577310E-19  -2.74858457505477E-01  -2.74858457502588E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88850214229018E-09   0.00000000000000E+00  -2.88850214229018E-09
      3.29539208468720E-18  -1.64657966252901E-01  -1.61386046773457E-01   0.00000000000000E+00   2.50549400022687E-11
     -8.80149682561597E-23  -1.04102527952663E-08  -1.03851978552641E-08  -2.53578834710988E-18
      1.27064430710436E-08
      0.00000000000000E+00  -1.31641061839548E-11   0.00000000000000E+00  -2.29583732242463E-13   8.02761589577076E-23
      1.31643528159663E-08   1.31641232322341E-08  -7.53808823788505E-19  -2.78087000266059E-01  -2.78087000263183E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87618042526656E-09   0.00000000000000E+00  -2.87618042526656E-09
      3.22986909937409E-18  -1.38197562463378E-01  -1.34956265062027E-01   0.00000000000000E+00   2.11417833186285E-11
     -8.56816859813395E-23  -1.03090845902861E-08  -1.02879428069676E-08  -2.47606027558559E-18
      1.27218204147936E-08
      0.00000000000000E+00  -1.30571989098452E-11   0.00000000000000E+00  -3.35946339759251E-13   7.86616577166500E-23
      1.30575324581367E-08   1.30571965117970E-08  -7.50116882001211E-19  -2.80193012953313E-01  -2.80193012950448E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86452389328617E-09   0.00000000000000E+00  -2.86452389328617E-09
      3.18582033078694E-18  -1.20813893192691E-01  -1.17602600287771E-01   0.00000000000000E+00   1.88038712420209E-11
     -8.40111765616055E-23  -1.02114764897528E-08  -1.01926726185109E-08  -2.43570344878573E-18
      1.27425798288561E-08
      0.00000000000000E+00  -1.29178704435014E-11   0.00000000000000E+00  -3.24146575913950E-13   7.67784783034827E-23
      1.29181918296770E-08   1.29178676831012E-08  -7.45085687145857E-19  -2.83072704657838E-01  -2.83072704655001E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.83657456847211E-09   0.00000000000000E+00  -2.83657456847211E-09
      3.12693470480087E-18  -9.85212468053445E-02  -9.53450320605183E-02   0.00000000000000E+00   1.65257345995188E-11
     -8.11825872205769E-23  -1.00978188492285E-08  -1.00812931146291E-08  -2.38184901765501E-18
      1.27706050378405E-08
      0.00000000000000E+00  -1.26404993371347E-11   0.00000000000000E+00  -4.80169956403827E-13   7.48998538926021E-23
      1.26409894333713E-08   1.26405092634150E-08  -7.37758135381041E-19  -2.87181170564650E-01  -2.87181170561862E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.78831385072575E-09   0.00000000000000E+00  -2.78831385072575E-09
      3.04879162642025E-18  -7.13174876732685E-02  -6.82134378947985E-02   0.00000000000000E+00   1.37022109146375E-11
     -7.29884460525835E-23  -9.86589762360379E-09  -9.85219541268923E-09  -2.31103349103921E-18
      1.28084390699694E-08
      0.00000000000000E+00  -1.19206202869021E-11   0.00000000000000E+00  -9.26838096837484E-13   7.62267426238363E-23
      1.19214779594922E-08   1.19205511213954E-08  -7.23972284380806E-19  -2.94162980641587E-01  -2.94162980638915E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.67235535814737E-09   0.00000000000000E+00  -2.67235535814737E-09
      2.94768564794025E-18  -4.33209186578234E-02  -4.04071519981314E-02   0.00000000000000E+00   1.00926396114266E-11
     -4.06506686556133E-23  -9.25828840285948E-09  -9.24819576324810E-09  -2.22371336355945E-18
      1.28584390699694E-08
      0.00000000000000E+00  -1.06628066108450E-11   0.00000000000000E+00  -1.22321001778566E-12   8.89902496102699E-23
      1.06640480402453E-08   1.06628248302276E-08  -6.95779931020780E-19  -3.06936419967946E-01  -3.06936419965491E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.45530047248440E-09   0.00000000000000E+00  -2.45530047248440E-09
      2.82492062431603E-18  -2.37303455045237E-02  -2.11444457109469E-02   0.00000000000000E+00   6.30788802663818E-12
      3.36784567383723E-23  -8.21383224576988E-09  -8.20752435774321E-09  -2.12914069329525E-18
      1.29084390699694E-08
      0.00000000000000E+00  -9.67575122007574E-12   0.00000000000000E+00  -9.54739226295979E-13   1.07041527934151E-22
      9.67668232975008E-09   9.67572759052389E-09  -6.62448389604567E-19  -3.21409043543551E-01  -3.21409043541279E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.27212302948190E-09   0.00000000000000E+00  -2.27212302948190E-09
      2.71131447284194E-18  -1.51346975925680E-02  -1.28020785724695E-02   0.00000000000000E+00   3.90868696533975E-12
      1.01330114751240E-22  -7.40751324800743E-09  -7.40360456104199E-09  -2.04886608323737E-18
      1.29584390699694E-08
      0.00000000000000E+00  -9.08022994402213E-12   0.00000000000000E+00  -5.69897437854121E-13   1.21713267064184E-22
      9.08075918137927E-09   9.08018928394154E-09  -6.29170024181027E-19  -3.35743816502590E-01  -3.35743816500435E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.15551486607057E-09   0.00000000000000E+00  -2.15551486607057E-09
      2.60353872953841E-18  -1.10380545895609E-02  -8.85632628451897E-03   0.00000000000000E+00   2.66243439710593E-12
      1.49687818884367E-22  -6.92733685226821E-09  -6.92467441787095E-09  -1.97436870535738E-18
      1.30084390699694E-08
      0.00000000000000E+00  -8.76198792959805E-12   0.00000000000000E+00  -2.97791697969147E-13   1.29485305299687E-22
      8.76230550702991E-09   8.76200771533207E-09  -5.96706819447772E-19  -3.49768014816953E-01  -3.49768014814826E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.12709784421781E-09   0.00000000000000E+00  -2.12709784421781E-09
      2.49718383732752E-18  -8.75173398163519E-03  -6.66129806263797E-03   0.00000000000000E+00   2.06775026645873E-12
      1.78928333770686E-22  -6.63697762138091E-09  -6.63490987111428E-09  -1.90047701787975E-18
      1.30584390699694E-08
      0.00000000000000E+00  -8.77842813755820E-12   0.00000000000000E+00   3.21040221712850E-14   1.31326870800801E-22
      8.77840569187070E-09   8.77843779589300E-09  -5.62116828743857E-19  -3.64705469048955E-01  -3.64705469046661E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.29396829828918E-09   0.00000000000000E+00  -2.29396829828918E-09
      2.38248542241306E-18  -7.30929363730301E-03  -5.26625432909942E-03   0.00000000000000E+00   1.83651195611114E-12
      1.93435738756838E-22  -6.48630600956015E-09  -6.48446949760385E-09  -1.82036859366920E-18
      1.30834390699694E-08
      0.00000000000000E+00  -8.84033149043607E-12   0.00000000000000E+00   1.37920022619161E-13   1.29231256197642E-22
      8.84023836489165E-09   8.84037628491440E-09  -5.44142918502764E-19  -3.72441327266007E-01  -3.72441327263592E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41513518477759E-09   0.00000000000000E+00  -2.41513518477759E-09
      2.32210704279362E-18  -6.75934984912433E-03  -4.73497043706944E-03   0.00000000000000E+00   1.74407656448802E-12
      1.94379244094392E-22  -6.42698517670141E-09  -6.42524110013673E-09  -1.77796412429086E-18
      1.31171890699694E-08
      0.00000000000000E+00  -8.83381051409434E-12   0.00000000000000E+00   5.69396830190269E-15   1.21949677612292E-22
      8.83379183187636E-09   8.83379752584478E-09  -5.20187092563013E-19  -3.82754688287042E-01  -3.82754688284607E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43471921523239E-09   0.00000000000000E+00  -2.43471921523239E-09
      2.23993526927953E-18  -6.15922271067669E-03  -4.14308499658882E-03   0.00000000000000E+00   1.56930882833165E-12
      1.87199850400314E-22  -6.40064761944092E-09  -6.39907831061240E-09  -1.71974817671651E-18
      1.31399703199694E-08
      0.00000000000000E+00  -8.77888736124424E-12   0.00000000000000E+00  -1.04608964899311E-13   1.14085811822487E-22
      8.77897721249687E-09   8.77887260353209E-09  -5.04548623314121E-19  -3.89484550206425E-01  -3.89484550204025E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40092070972857E-09   0.00000000000000E+00  -2.40092070972857E-09
      2.18523929436102E-18  -5.81459477349366E-03  -3.80511243344761E-03   0.00000000000000E+00   1.45936958571524E-12
      1.76757732009615E-22  -6.37941126338948E-09  -6.37795189380359E-09  -1.68069067104690E-18
      1.31553476637194E-08
      0.00000000000000E+00  -8.72056595311746E-12   0.00000000000000E+00  -1.73513997717075E-13   1.07577274364304E-22
      8.72073687099459E-09   8.72056335699698E-09  -4.94328794885996E-19  -3.93881247223071E-01  -3.93881247220717E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.35313196666103E-09   0.00000000000000E+00  -2.35313196666103E-09
      2.14905437522056E-18  -5.60905557051402E-03  -3.60288732938412E-03   0.00000000000000E+00   1.36229368750764E-12
      1.67410731895659E-22  -6.36879368402361E-09  -6.36743139033593E-09  -1.65472558033457E-18
      1.31761070777819E-08
      0.00000000000000E+00  -8.60989304478239E-12   0.00000000000000E+00  -2.50445443130710E-13   9.77483696357053E-23
      8.61015546407368E-09   8.60990501863064E-09  -4.81310973687887E-19  -3.99479973355224E-01  -3.99479973352980E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.24460143016002E-09   0.00000000000000E+00  -2.24460143016002E-09
      2.10245776472659E-18  -5.36880254273755E-03  -3.36330398689242E-03   0.00000000000000E+00   1.22749816238580E-12
      1.52713095613996E-22  -6.36653108663312E-09  -6.36530358847058E-09  -1.62114679103870E-18
      1.32041322867663E-08
      0.00000000000000E+00  -8.39378237813308E-12   0.00000000000000E+00  -3.69439407795951E-13   8.34178616979021E-23
      8.39418059259530E-09   8.39381115318759E-09  -4.65710462480036E-19  -4.06188968395127E-01  -4.06188968393104E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.02281623305945E-09   0.00000000000000E+00  -2.02281623305945E-09
      2.04576791705811E-18  -5.09837751717167E-03  -3.09108492687304E-03   0.00000000000000E+00   1.04306070825265E-12
      1.30512764806742E-22  -6.37203798083651E-09  -6.37099492012812E-09  -1.58005745457808E-18
      1.32419663188952E-08
      0.00000000000000E+00  -7.91214857621681E-12   0.00000000000000E+00  -6.20054894259312E-13   6.39456544709999E-23
      7.91276874157173E-09   7.91214868667754E-09  -4.50691685728239E-19  -4.12694374001890E-01  -4.12694374000391E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.49885565206955E-09   0.00000000000000E+00  -1.49885565206955E-09
      1.98906016416112E-18  -4.82997674750146E-03  -2.80935636998535E-03   0.00000000000000E+00   6.75171461788892E-13
      9.94452019429320E-23  -6.41396820606986E-09  -6.41329303460797E-09  -1.53836847843288E-18
      1.32919663188952E-08
      0.00000000000000E+00  -6.50279108376731E-12   0.00000000000000E+00  -1.38987752256399E-12   4.00179320996052E-23
      6.50421241299349E-09   6.50282253547097E-09  -4.53844245783247E-19  -4.11813372802625E-01  -4.11813372802617E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.10606095108277E-12   0.00000000000000E+00  -8.10606095108277E-12
      1.98865486111357E-18  -4.61674968495225E-03  -2.57047454595197E-03   0.00000000000000E+00  -1.71934697583062E-13
      6.02763883684943E-23  -6.49454453982233E-09  -6.49471647451985E-09  -1.53481061533032E-18
      1.33419663188952E-08
      0.00000000000000E+00  -3.92562775772411E-12   0.00000000000000E+00  -2.57821292471770E-12   1.62063192535852E-23
      3.92819121811390E-09   3.92561300518919E-09  -5.00240258503646E-19  -3.93452924794922E-01  -3.93452924797519E-01
      0.00000000000000E+00   0.00000000000000E+00   2.59693463868954E-09   0.00000000000000E+00   2.59693463868954E-09
      2.11850159304804E-18  -4.59622734869892E-03  -2.54117685526830E-03   0.00000000000000E+00  -1.71321955987805E-12
      1.96847698729811E-23  -6.52083442431890E-09  -6.52254764387875E-09  -1.61826133454440E-18
      1.33919663188952E-08
      0.00000000000000E+00  -1.21225868640215E-12   0.00000000000000E+00  -2.71899236348735E-12  -1.21377149547882E-23
      1.21497699614369E-09   1.21225800378019E-09  -6.00074029250405E-19  -3.53552336884609E-01  -3.53552336889853E-01
      0.00000000000000E+00   0.00000000000000E+00   5.24358906962606E-09   0.00000000000000E+00   5.24358906962606E-09
      2.38068104652935E-18  -5.44103080482737E-03  -3.40700379963835E-03   0.00000000000000E+00  -4.40790200027951E-12
     -3.15510426432863E-23  -6.45143917140592E-09  -6.45584707340623E-09  -1.78060701727894E-18
      1.34419663188952E-08
      0.00000000000000E+00   3.93554698934252E-13   0.00000000000000E+00  -1.66713170769375E-12  -3.43327285039468E-23
     -3.91831098541440E-10  -3.93498230249168E-10  -7.36715826349100E-19  -2.96639932787761E-01  -2.96639932794302E-01
      0.00000000000000E+00   0.00000000000000E+00   6.54124581746153E-09   0.00000000000000E+00   6.54124581746153E-09
      2.70774333740242E-18  -1.04878259495442E-02  -8.55087435485251E-03   0.00000000000000E+00  -8.79118086022356E-12
     -7.02539812380359E-23  -6.13895640635207E-09  -6.14774758721237E-09  -1.97102751105332E-18
      1.34919663188952E-08
      0.00000000000000E+00   1.50138591913144E-12   0.00000000000000E+00  -1.21417889282302E-12  -4.14585623562185E-23
     -1.50017437479345E-09  -1.50138855368632E-09  -8.73350403102241E-19  -2.34529781533814E-01  -2.34529781540464E-01
      0.00000000000000E+00   0.00000000000000E+00   6.64972430581498E-09   0.00000000000000E+00   6.64972430581498E-09
      3.04022955269317E-18  -2.95108553652113E-02  -2.78887871756500E-02   0.00000000000000E+00  -1.62860012077520E-11
     -8.14497350923917E-23  -5.13204975092084E-09  -5.14833575212867E-09  -2.16687914959093E-18
      1.35169663188952E-08
      0.00000000000000E+00   1.90899286285844E-12   0.00000000000000E+00  -9.53887540178839E-13  -4.26946387584720E-23
     -1.90805312473974E-09  -1.90900701227996E-09  -9.37166039036233E-19  -2.03502202724406E-01  -2.03502202730796E-01
      0.00000000000000E+00   0.00000000000000E+00   6.38959763172408E-09   0.00000000000000E+00   6.38959763172408E-09
      3.19996949348627E-18  -4.34039728504400E-02  -4.19922853937502E-02   0.00000000000000E+00  -2.43904779513969E-11
     -8.55329346235716E-23  -4.45620014149264E-09  -4.48059061944413E-09  -2.26280345445004E-18
      1.35507163188952E-08
      0.00000000000000E+00   2.14044160062141E-12   0.00000000000000E+00  -5.06721190090922E-13  -4.38277164054618E-23
     -2.13995211626998E-09  -2.14045883746011E-09  -1.01612239586990E-18  -1.63291770201907E-01  -1.63291770207923E-01
      0.00000000000000E+00   0.00000000000000E+00   6.01629159136708E-09   0.00000000000000E+00   6.01629159136708E-09
      3.40301933469491E-18  -6.59287632011870E-02  -6.47076135419162E-02   0.00000000000000E+00  -3.31605653497157E-11
     -9.19501158534596E-23  -3.84267218855715E-09  -3.87583275390695E-09  -2.38689693882502E-18
      1.35734975688952E-08
      0.00000000000000E+00   2.12455246108451E-12   0.00000000000000E+00  -1.55143619964752E-13  -4.45732276041878E-23
     -2.12436647439562E-09  -2.12452161801563E-09  -1.06597160115437E-18  -1.36876196016880E-01  -1.36876196022532E-01
      0.00000000000000E+00   0.00000000000000E+00   5.65246628344917E-09   0.00000000000000E+00   5.65246628344917E-09
      3.53178958221474E-18  -8.21111421491199E-02  -8.09995974339096E-02   0.00000000000000E+00  -4.21968546372846E-11
     -9.64423883946311E-23  -3.48574781079616E-09  -3.52794466543354E-09  -2.46581798106037E-18
      1.35888749126452E-08
      0.00000000000000E+00   2.06237357399501E-12   0.00000000000000E+00  -2.89253322070180E-15  -4.50778600547371E-23
     -2.06237051777848E-09  -2.06237341031175E-09  -1.09787485516532E-18  -1.19531593488677E-01  -1.19531593494059E-01
      0.00000000000000E+00   0.00000000000000E+00   5.38227986443026E-09   0.00000000000000E+00   5.38227986443026E-09
      3.61455474984879E-18  -9.32931075011823E-02  -9.22471066620134E-02   0.00000000000000E+00  -4.85659207323631E-11
     -9.94924716156276E-23  -3.27134053338608E-09  -3.31990645411854E-09  -2.51667989468347E-18
      1.36096343267077E-08
      0.00000000000000E+00   1.95188435513436E-12   0.00000000000000E+00   5.46903139765026E-14  -4.57334417902200E-23
     -1.95191615141422E-09  -1.95186146110028E-09  -1.13782184603697E-18  -9.73105140820979E-02  -9.73105140871442E-02
      0.00000000000000E+00   0.00000000000000E+00   5.04624478149381E-09   0.00000000000000E+00   5.04624478149381E-09
      3.71931183472855E-18  -1.08511725543916E-01  -1.07536779613814E-01   0.00000000000000E+00  -5.38636721827986E-11
     -1.03584692010933E-22  -3.04051964821059E-09  -3.09438332039349E-09  -2.58148998869158E-18
      1.36376595356921E-08
      0.00000000000000E+00   1.73953932271056E-12   0.00000000000000E+00   1.67393654745150E-13  -4.65232143210967E-23
     -1.73962913820803E-09  -1.73946174455333E-09  -1.18510238477820E-18  -7.02670084235833E-02  -7.02670084281234E-02
      0.00000000000000E+00   0.00000000000000E+00   4.54014834436019E-09   0.00000000000000E+00   4.54014834436019E-09
      3.84655044089931E-18  -1.29062001132258E-01  -1.28179589954396E-01   0.00000000000000E+00  -5.95156437660881E-11
     -1.09026865335953E-22  -2.74117095604063E-09  -2.80068659980682E-09  -2.66144805612111E-18
      1.36754935678210E-08
      0.00000000000000E+00   1.30098070254462E-12   0.00000000000000E+00   4.00385618263881E-13  -4.72918279530436E-23
     -1.30131845949328E-09  -1.30091807387506E-09  -1.23195564102293E-18  -4.26295197186500E-02  -4.26295197222975E-02
      0.00000000000000E+00   0.00000000000000E+00   3.64751306853913E-09   0.00000000000000E+00   3.64751306853913E-09
      3.98455056752502E-18  -1.56928514040679E-01  -1.56189173492923E-01   0.00000000000000E+00  -6.19646143593694E-11
     -1.15844444697003E-22  -2.28463038030461E-09  -2.34659499466410E-09  -2.75259492650209E-18
      1.37254935678210E-08
      0.00000000000000E+00   6.96917865930713E-13   0.00000000000000E+00   5.03427469360227E-13  -4.77684054795643E-23
     -6.97434506599919E-10  -6.96931079130606E-10  -1.26361802913529E-18  -2.34267832192707E-02  -2.34267832216872E-02
      0.00000000000000E+00   0.00000000000000E+00   2.41650966664719E-09   0.00000000000000E+00   2.41650966664719E-09
      4.10537605085738E-18  -1.92136710552994E-01  -1.91594924029274E-01   0.00000000000000E+00  -5.56812336828424E-11
     -1.23072083456145E-22  -1.66389735383363E-09  -1.71957858751659E-09  -2.84175802172209E-18
      1.37754935678210E-08
      0.00000000000000E+00   3.37437564500453E-13   0.00000000000000E+00   3.18678476741740E-13  -4.79393741336329E-23
     -3.37691871996942E-10  -3.37373193520248E-10  -1.27736093663336E-18  -1.50003432557766E-02  -1.50003432573152E-02
      0.00000000000000E+00   0.00000000000000E+00   1.53858984068580E-09   0.00000000000000E+00   1.53858984068580E-09
      4.18230554289167E-18  -2.21349508610272E-01  -2.20971042296977E-01   0.00000000000000E+00  -4.46327596312010E-11
     -1.28338675906305E-22  -1.15658388753420E-09  -1.20121664716553E-09  -2.90494460625831E-18
      1.38254935678210E-08
      0.00000000000000E+00   1.96731427098522E-13   0.00000000000000E+00   1.25975609036680E-13  -4.80007268712740E-23
     -1.96884957058464E-10  -1.96758981449476E-10  -1.28413699592000E-18  -1.09679922366484E-02  -1.09679922376737E-02
      0.00000000000000E+00   0.00000000000000E+00   1.02536777449729E-09   0.00000000000000E+00   1.02536777449729E-09
      4.23357393161653E-18  -2.42284082668258E-01  -2.42023015046322E-01   0.00000000000000E+00  -3.19530896595167E-11
     -1.31875527872095E-22  -7.96655703388168E-10  -8.28608793047817E-10  -2.94943693569653E-18
      1.38754935678210E-08
      0.00000000000000E+00   1.42359342671666E-13   0.00000000000000E+00   4.95173782727482E-14  -4.80218094247491E-23
     -1.42433760156449E-10  -1.42384242778224E-10  -1.28824925127064E-18  -8.70954580405191E-03  -8.70954580476868E-03
      0.00000000000000E+00   0.00000000000000E+00   7.16771867134693E-10   0.00000000000000E+00   7.16771867134693E-10
      4.26941252497327E-18  -2.56065934857052E-01  -2.55884966200192E-01   0.00000000000000E+00  -2.07896440058737E-11
     -1.34090257941272E-22  -5.53597980350461E-10  -5.74387624356469E-10  -2.98116327370263E-18
      1.39254935678210E-08
      0.00000000000000E+00   1.16459126779144E-13   0.00000000000000E+00   2.52294242207144E-14  -4.80243474535244E-23
     -1.16467321471879E-10  -1.16442092047706E-10  -1.29111371350828E-18  -7.28124729420845E-03  -7.28124729476342E-03
      0.00000000000000E+00   0.00000000000000E+00   5.54968772421793E-10   0.00000000000000E+00   5.54968772421793E-10
      4.29716096359436E-18  -2.65861044109852E-01  -2.65722882187531E-01   0.00000000000000E+00  -1.42227865407763E-11
     -1.35567028981517E-22  -4.24303893833203E-10  -4.38526680374115E-10  -3.00604725008608E-18
      1.39504935678210E-08
      0.00000000000000E+00   1.05713292525863E-13   0.00000000000000E+00   2.23368709289017E-14  -4.80216538706606E-23
     -1.05723847448672E-10  -1.05701510577792E-10  -1.29228924663469E-18  -6.73544571341685E-03  -6.73544571390806E-03
      0.00000000000000E+00   0.00000000000000E+00   4.91204586693395E-10   0.00000000000000E+00   4.91204586693395E-10
      4.30944107826169E-18  -2.69980319619380E-01  -2.69858864246560E-01   0.00000000000000E+00  -1.15583593453313E-11
     -1.36158644457173E-22  -3.73944716770094E-10  -3.85503076115561E-10  -3.01715183162700E-18
      1.39842435678210E-08
      0.00000000000000E+00   9.79983346004310E-14   0.00000000000000E+00   1.33504303147845E-14  -4.80150379678209E-23
     -9.79833725393768E-11  -9.79700221091101E-11  -1.29363657802797E-18  -6.13987236044694E-03  -6.13987236090645E-03
      0.00000000000000E+00   0.00000000000000E+00   4.59509585869982E-10   0.00000000000000E+00   4.59509585869982E-10
      4.32494952678480E-18  -2.75128434476081E-01  -2.75014529501347E-01   0.00000000000000E+00  -1.04753589770396E-11
     -1.36871842202255E-22  -3.51064204783713E-10  -3.61539563760890E-10  -3.03131294875683E-18
      1.40070248178210E-08
      0.00000000000000E+00   9.32224082656397E-14   0.00000000000000E+00   1.28282124735560E-14  -4.80092245784302E-23
     -9.32458293346107E-11  -9.32330011221852E-11  -1.29444767541050E-18  -5.79798928861223E-03  -5.79798928904748E-03
      0.00000000000000E+00   0.00000000000000E+00   4.35248780383132E-10   0.00000000000000E+00   4.35248780383132E-10
      4.33486503806291E-18  -2.78346239757980E-01  -2.78238486319988E-01   0.00000000000000E+00  -9.48606118792067E-12
     -1.37303854268898E-22  -3.32529718072918E-10  -3.42015779260976E-10  -3.04041736265241E-18
      1.40224021615710E-08
      0.00000000000000E+00   9.00078424633762E-14   0.00000000000000E+00   1.34198363011976E-14  -4.80046469036072E-23
     -8.99810400884238E-11  -8.99676202521706E-11  -1.29494930209035E-18  -5.59411218137940E-03  -5.59411218180231E-03
      0.00000000000000E+00   0.00000000000000E+00   4.22910020939271E-10   0.00000000000000E+00   4.22910020939271E-10
      4.34136827083021E-18  -2.80448455311536E-01  -2.80343560698702E-01   0.00000000000000E+00  -9.06485351026381E-12
     -1.37580578186513E-22  -3.23877547176613E-10  -3.32942400687014E-10  -3.04641896873986E-18
      1.40431615756335E-08
      0.00000000000000E+00   8.61503635006601E-14   0.00000000000000E+00   1.24183491530050E-14  -4.79975296845735E-23
     -8.61697315777922E-11  -8.61573132286872E-11  -1.29555543473769E-18  -5.35584924804280E-03  -5.35584924846149E-03
      0.00000000000000E+00   0.00000000000000E+00   4.18686851954622E-10   0.00000000000000E+00   4.18686851954622E-10
      4.35005996455246E-18  -2.83329307525595E-01  -2.83224542988362E-01   0.00000000000000E+00  -9.19632247337799E-12
     -1.37956160449221E-22  -3.23333216252392E-10  -3.32529538725908E-10  -3.05450452981478E-18
      1.40711867846178E-08
      0.00000000000000E+00   8.15581266402838E-14   0.00000000000000E+00   1.19329358059151E-14  -4.79864223178386E-23
     -8.15719727413290E-11  -8.15600398055711E-11  -1.29625996733296E-18  -5.08797501033798E-03  -5.08797501076047E-03
      0.00000000000000E+00   0.00000000000000E+00   4.22494290536376E-10   0.00000000000000E+00   4.22494290536376E-10
      4.36190045533945E-18  -2.87464922775918E-01  -2.87357510082064E-01   0.00000000000000E+00  -9.90922662720409E-12
     -1.38496423783292E-22  -3.31025024103499E-10  -3.40934250730842E-10  -3.06564048800649E-18
      1.41090208167468E-08
      0.00000000000000E+00   7.41187029264741E-14   0.00000000000000E+00   1.43807531283344E-14  -4.79677114686740E-23
     -7.41507314505074E-11  -7.41363506974270E-11  -1.29696060963377E-18  -4.82277314726581E-03  -4.82277314772963E-03
      0.00000000000000E+00   0.00000000000000E+00   4.63826182379128E-10   0.00000000000000E+00   4.63826182379128E-10
      4.37944887002581E-18  -2.94557368099431E-01  -2.94434593493959E-01   0.00000000000000E+00  -1.33255840680396E-11
     -1.39460504715148E-22  -3.76364247613498E-10  -3.89689831681677E-10  -3.08248826039204E-18
      1.41590208167468E-08
      0.00000000000000E+00   6.43831607824763E-14   0.00000000000000E+00   1.54878562711442E-14  -4.79366702953206E-23
     -6.43710464168371E-11  -6.43555585606139E-11  -1.29745911570259E-18  -4.61252533631952E-03  -4.61252533686222E-03
      0.00000000000000E+00   0.00000000000000E+00   5.42696380094218E-10   0.00000000000000E+00   5.42696380094218E-10
      4.40658368903052E-18  -3.07450221546739E-01  -3.07299514864677E-01   0.00000000000000E+00  -1.96847497996631E-11
     -1.41301866874824E-22  -4.58656071733802E-10  -4.78340821533606E-10  -3.10912457332794E-18
      1.42090208167468E-08
      0.00000000000000E+00   5.42802396896483E-14   0.00000000000000E+00   1.68910102245039E-14  -4.78991179990787E-23
     -5.43597776588573E-11  -5.43428866486806E-11  -1.29752373552395E-18  -4.60104425223130E-03  -4.60104425279954E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68240592502374E-10   0.00000000000000E+00   5.68240592502374E-10
      4.43499571865564E-18  -3.21941865815770E-01  -3.21779955972330E-01   0.00000000000000E+00  -2.29726766194299E-11
     -1.43396723121171E-22  -4.90925029234090E-10  -5.13897705853663E-10  -3.13747198313169E-18
      1.42590208167468E-08
      0.00000000000000E+00   2.24101158786365E-14   0.00000000000000E+00   4.33917271972455E-14  -4.78346959249492E-23
     -2.24030469537181E-11  -2.23596552265687E-11  -1.29606491921042E-18  -5.49015982389025E-03  -5.49015982439753E-03
      0.00000000000000E+00   0.00000000000000E+00   5.07275584079611E-10   0.00000000000000E+00   5.07275584079611E-10
      4.46035949785962E-18  -3.36259000869310E-01  -3.36106222808044E-01   0.00000000000000E+00  -2.18010834414625E-11
     -1.45336317295352E-22  -4.63114845411458E-10  -4.84915928853066E-10  -3.16429457864920E-18
      1.43090208167468E-08
      0.00000000000000E+00  -1.27480495244047E-13   0.00000000000000E+00   1.83432612032993E-13  -4.76363047011678E-23
      1.27340998536970E-10   1.27524431148956E-10  -1.28724452082881E-18  -1.07487111738722E-02  -1.07487111741124E-02
      0.00000000000000E+00   0.00000000000000E+00   2.40257626625781E-10   0.00000000000000E+00   2.40257626625781E-10
      4.47237237919091E-18  -3.50291287961794E-01  -3.50175417012818E-01   0.00000000000000E+00  -1.35325989237865E-11
     -1.46525046070600E-22  -3.54249458850785E-10  -3.67782057774718E-10  -3.18512785836210E-18
      1.43590208167468E-08
      0.00000000000000E+00  -6.26564797229748E-13   0.00000000000000E+00   6.00251431543989E-13  -4.69973108343413E-23
      6.26004478611245E-10   6.26604730042742E-10  -1.25396112634934E-18  -3.02022614739972E-02  -3.02022614734154E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.81746782024498E-10   0.00000000000000E+00  -5.81746782024498E-10
      4.44328504008968E-18  -3.65275600914891E-01  -3.65261478849728E-01   0.00000000000000E+00   1.15321296390749E-11
     -1.45561281818476E-22  -5.63900776571626E-11  -4.48579480182332E-11  -3.18932391374034E-18
      1.43840208167468E-08
      0.00000000000000E+00  -9.54726043272241E-13   0.00000000000000E+00   7.90071516937900E-13  -4.65428313318761E-23
      9.54002128818527E-10   9.54792200335418E-10  -1.22941022714636E-18  -4.42423740281151E-02  -4.42423740270109E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.10418458855775E-09   0.00000000000000E+00  -1.10418458855775E-09
      4.41568042537574E-18  -3.73015327733345E-01  -3.73062411464012E-01   0.00000000000000E+00   2.62909268675094E-11
     -1.44433752495192E-22   1.23101461354942E-10   1.49392388222307E-10  -3.18627019822938E-18
      1.44177708167468E-08
      0.00000000000000E+00  -1.20941149954871E-12   0.00000000000000E+00   5.28926895333597E-13  -4.58366666494407E-23
      1.20893007672440E-09   1.20945900361969E-09  -1.18882111088527E-18  -6.68541292465048E-02  -6.68541292450297E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.47514673697259E-09   0.00000000000000E+00  -1.47514673697259E-09
      4.36589422300291E-18  -3.83306222396304E-01  -3.83389950543899E-01   0.00000000000000E+00   3.52301950976181E-11
     -1.42335438744588E-22   2.30457538255381E-10   2.65687733352857E-10  -3.17707311211765E-18
      1.44405520667468E-08
      0.00000000000000E+00  -1.36233298699924E-12   0.00000000000000E+00   4.83128674235761E-13  -4.53412382229224E-23
      1.36188601516337E-09   1.36236914383756E-09  -1.15894248065175E-18  -8.30635867702056E-02  -8.30635867685479E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.65768858009791E-09   0.00000000000000E+00  -1.65768858009791E-09
      4.32813000503756E-18  -3.90011823256269E-01  -3.90104889912897E-01   0.00000000000000E+00   3.81599251777003E-11
     -1.40754924888734E-22   2.57159511082790E-10   2.95319436260349E-10  -3.16918752438581E-18
      1.44559294104968E-08
      0.00000000000000E+00  -1.46354588740194E-12   0.00000000000000E+00   4.70588047319596E-13  -4.49951970855864E-23
      1.46308627273315E-09   1.46355686078043E-09  -1.13792323250635E-18  -9.42540477838041E-02  -9.42540477820518E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.75234162796447E-09   0.00000000000000E+00  -1.75234162796447E-09
      4.30118364545691E-18  -3.94388117640772E-01  -3.94479127638915E-01   0.00000000000000E+00   3.90821136167432E-11
     -1.39635915286706E-22   2.49702653567386E-10   2.88784767183990E-10  -3.16326041295057E-18
      1.44766888245593E-08
      0.00000000000000E+00  -1.59258774317851E-12   0.00000000000000E+00   4.45118757227711E-13  -4.44737727374314E-23
      1.59216147737262E-09   1.59260659612980E-09  -1.10879810112517E-18  -1.09475016713063E-01  -1.09475016711238E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.82478131611303E-09   0.00000000000000E+00  -1.82478131611303E-09
      4.26330225454221E-18  -3.99951028148823E-01  -4.00024206648452E-01   0.00000000000000E+00   3.95442019446757E-11
     -1.38065139460524E-22   1.92630518038752E-10   2.32174719983289E-10  -3.15450415341703E-18
      1.45047140335436E-08
      0.00000000000000E+00  -1.84405863365272E-12   0.00000000000000E+00   5.69775353516748E-13  -4.34334498620574E-23
      1.84348487114530E-09   1.84405464649877E-09  -1.06847179787971E-18  -1.30028263241418E-01  -1.30028263239504E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.91390040752235E-09   0.00000000000000E+00  -1.91390040752235E-09
      4.20966479564612E-18  -4.06589703844327E-01  -4.06611747861392E-01   0.00000000000000E+00   4.01342463644488E-11
     -1.35824851864742E-22   2.97115146592987E-11   6.98457610236116E-11  -3.14119299776641E-18
      1.45425480656725E-08
      0.00000000000000E+00  -2.50185064153303E-12   0.00000000000000E+00   9.70923843447414E-13  -3.99750215932943E-23
      2.50087099529117E-09   2.50184191913458E-09  -1.01184971406184E-18  -1.57903261756958E-01  -1.57903261754866E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.09242027789449E-09   0.00000000000000E+00  -2.09242027789449E-09
      4.13050009962508E-18  -4.12914743999945E-01  -4.12785812999549E-01   0.00000000000000E+00   4.27721393930383E-11
     -1.32400175670941E-22  -4.52193780633055E-10  -4.09421641240149E-10  -3.11865038556324E-18
      1.45925480656725E-08
      0.00000000000000E+00  -4.32671372510938E-12   0.00000000000000E+00   1.89118121952545E-12  -2.49327229119967E-23
      4.32484836632762E-09   4.32673954754712E-09  -9.37126427024773E-19  -1.93014340697237E-01  -1.93014340694871E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.36646773197727E-09   0.00000000000000E+00  -2.36646773197727E-09
      4.01217671302622E-18  -4.11497780627758E-01  -4.10880295823692E-01   0.00000000000000E+00   4.87863661611536E-11
     -1.26721748993173E-22  -2.00905818173087E-09  -1.96027181556984E-09  -3.07505028600145E-18
      1.46425480656725E-08
      0.00000000000000E+00  -7.37825511882945E-12   0.00000000000000E+00   3.07166257126653E-12   9.27622572326891E-24
      7.37518492788297E-09   7.37825659045425E-09  -8.72702429146622E-19  -2.22018713759499E-01  -2.22018713756909E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.59019343830575E-09   0.00000000000000E+00  -2.59019343830575E-09
      3.88266704111093E-18  -3.92321195329396E-01  -3.90812853624179E-01   0.00000000000000E+00   5.44574922662763E-11
     -1.19594098147719E-22  -4.84252064441463E-09  -4.78806315214848E-09  -3.00996461196430E-18
      1.46925480656725E-08
      0.00000000000000E+00  -1.05615018657051E-11   0.00000000000000E+00   3.17770574796716E-12   4.80793687089574E-23
      1.05583079523027E-08   1.05614856580507E-08  -8.25997822325270E-19  -2.42735653225666E-01  -2.42735653222914E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.75225544777605E-09   0.00000000000000E+00  -2.75225544777605E-09
      3.74505426872213E-18  -3.51608446672214E-01  -3.49148276831228E-01   0.00000000000000E+00   5.64252438757976E-11
     -1.11555629975431E-22  -7.86565545415034E-09  -7.80923021027465E-09  -2.91905644639686E-18
      1.47425480656725E-08
      0.00000000000000E+00  -1.24865675575749E-11   0.00000000000000E+00   1.92120392512063E-12   7.31997200157819E-23
      1.24846336125085E-08   1.24865548164337E-08  -7.96193124396066E-19  -2.56365823437105E-01  -2.56365823434238E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86706435595272E-09   0.00000000000000E+00  -2.86706435595272E-09
      3.60170105092449E-18  -2.94247313722126E-01  -2.91216762020613E-01   0.00000000000000E+00   5.07523954019251E-11
     -1.03641648048406E-22  -9.67024285588283E-09  -9.61949046048101E-09  -2.80550792652843E-18
      1.47925480656725E-08
      0.00000000000000E+00  -1.32227031262932E-11   0.00000000000000E+00   7.39878714293957E-13   8.26692407002280E-23
      1.32220017824329E-08   1.32227416611473E-08  -7.76274620132083E-19  -2.66096371511590E-01  -2.66096371508687E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90276169417941E-09   0.00000000000000E+00  -2.90276169417941E-09
      3.45656296621552E-18  -2.32147224456673E-01  -2.28895913525307E-01   0.00000000000000E+00   3.84682913564000E-11
     -9.54915610228863E-23  -1.03584482583242E-08  -1.03199799669679E-08  -2.68028834608344E-18
      1.48175480656725E-08
      0.00000000000000E+00  -1.32736769554434E-11   0.00000000000000E+00   1.10963142550508E-13   8.33744390815395E-23
      1.32735674847166E-08   1.32736784478592E-08  -7.68323096651309E-19  -2.70194849268536E-01  -2.70194849265622E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91397664344679E-09   0.00000000000000E+00  -2.91397664344679E-09
      3.38371355012935E-18  -2.01169256922997E-01  -1.97905399992638E-01   0.00000000000000E+00   3.03788377345514E-11
     -9.16648017036119E-23  -1.03900806421468E-08  -1.03597018044124E-08  -2.61539045347804E-18
      1.48512980656725E-08
      0.00000000000000E+00  -1.32661456869924E-11   0.00000000000000E+00  -2.73511582654432E-15   8.19599537635214E-23
      1.32661429597621E-08   1.32661402246464E-08  -7.58765389295787E-19  -2.75324590402144E-01  -2.75324590399258E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88619308141168E-09   0.00000000000000E+00  -2.88619308141168E-09
      3.28630453363171E-18  -1.61041073946654E-01  -1.57770806067384E-01   0.00000000000000E+00   2.45719123246052E-11
     -8.76971016520893E-23  -1.04045190555592E-08  -1.03799471432347E-08  -2.52753914433592E-18
      1.48740793156725E-08
      0.00000000000000E+00  -1.31496865602132E-11   0.00000000000000E+00  -2.44518575503117E-13   7.99096602778046E-23
      1.31499490632069E-08   1.31497045446315E-08  -7.53025140709897E-19  -2.78534925692304E-01  -2.78534925689430E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87329427454264E-09   0.00000000000000E+00  -2.87329427454264E-09
      3.22084729843978E-18  -1.34701444506846E-01  -1.31463778247042E-01   0.00000000000000E+00   2.07425700653151E-11
     -8.53577476967305E-23  -1.02971528401540E-08  -1.02764102700888E-08  -2.46782215772989E-18
      1.49048340031725E-08
      0.00000000000000E+00  -1.29787635042700E-11   0.00000000000000E+00  -2.67103241083878E-13   7.72811375962770E-23
      1.29790095454330E-08   1.29787424421919E-08  -7.45462102254496E-19  -2.82837190989841E-01  -2.82837190987004E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.83644725594051E-09   0.00000000000000E+00  -2.83644725594051E-09
      3.13361324947310E-18  -1.01318363297560E-01  -9.81229310126174E-02   0.00000000000000E+00   1.72724467725561E-11
     -8.15470441238772E-23  -1.01595676330239E-08  -1.01422951862515E-08  -2.38815114721860E-18
      1.49463528312975E-08
      0.00000000000000E+00  -1.25491138236132E-11   0.00000000000000E+00  -4.37180858384218E-13   7.48804389469773E-23
      1.25495869823076E-08   1.25491498014493E-08  -7.34081574517713E-19  -2.89119757778574E-01  -2.89119757775811E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.76341892985360E-09   0.00000000000000E+00  -2.76341892985360E-09
      3.01887933388714E-18  -6.26006347745162E-02  -5.95175415337407E-02   0.00000000000000E+00   1.29969269515284E-11
     -6.70171744566617E-23  -9.79872779854720E-09  -9.78573087159574E-09  -2.28479775936942E-18
      1.49963528312975E-08
      0.00000000000000E+00  -1.14228218112373E-11   0.00000000000000E+00  -1.09691445181652E-12   8.05351222828328E-23
      1.14239055478426E-08   1.14228086333909E-08  -7.12016018962013E-19  -2.99720048656928E-01  -2.99720048654346E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.58246177679719E-09   0.00000000000000E+00  -2.58246177679719E-09
      2.88975624504728E-18  -3.27558864773798E-02  -2.99706124623186E-02   0.00000000000000E+00   8.44467709626984E-12
     -9.89568474954940E-24  -8.84879153368995E-09  -8.84034685659369E-09  -2.17774022608527E-18
      1.50000000000000E-08
      0.00000000000000E+00  -1.12022107524648E-11   0.00000000000000E+00  -2.92478602386086E-12   8.09462341743502E-23
      1.12051430925293E-08   1.12022183065055E-08  -7.10297567088997E-19  -3.00521268968366E-01  -3.00521268965800E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.56545982999741E-09   0.00000000000000E+00  -2.56545982999741E-09
      2.88039958024790E-18  -3.07879011062665E-02  -2.80667756676155E-02   0.00000000000000E+00   8.97234208031939E-12
     -3.02882046121165E-24  -8.64573081858840E-09  -8.63675847650809E-09  -2.17010201315890E-18
}
